/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.dialogs.CWizardDialog;
import com.kms.katalon.composer.components.impl.tree.WebElementTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.components.wizard.RenameWizard;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ObjectRepositoryController;
import com.kms.katalon.entity.repository.WebElementEntity;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RenameTestObjectHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    @Named(value="activeShell")
    private Shell parentShell;

    @PostConstruct
    public void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/RENAME_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                Object eventData = event.getProperty("org.eclipse.e4.data");
                if (eventData instanceof WebElementTreeEntity var3_4) {
                    RenameTestObjectHandler.this.execute((WebElementTreeEntity)webElementTreeEntity);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private void execute(WebElementTreeEntity webElementTreeEntity) {
        block5: {
            try {
                void webElement;
                List existingNames;
                RenameWizard renameWizard;
                CWizardDialog wizardDialog;
                void var3_2;
                WebElementEntity webElementEntity;
                Object object = webElementTreeEntity.getObject();
                if (!(object instanceof WebElementEntity) || (webElementEntity = (WebElementEntity)object) != (WebElementEntity)var3_2 || (wizardDialog = new CWizardDialog(this.parentShell, (IWizard)(renameWizard = new RenameWizard((ITreeEntity)webElementTreeEntity, existingNames = FolderController.getInstance().getChildrenNames(webElement.getParentFolder()))))).open() != 0) break block5;
                String oldName = webElement.getName();
                String pk = webElement.getId();
                String oldIdForDisplay = webElement.getIdForDisplay();
                String newNameValue = renameWizard.getNewNameValue();
                try {
                    if (!StringUtils.equals((String)newNameValue, (String)oldName)) {
                        webElement.setName(newNameValue);
                        ObjectRepositoryController.getInstance().updateTestObject((WebElementEntity)webElement);
                        String newIdForDisplay = webElement.getIdForDisplay();
                        this.eventBroker.post("EXPLORER/RENAMED_SELECTED_ITEM", (Object)new Object[]{oldIdForDisplay, newIdForDisplay});
                    }
                    this.partService.saveAll(false);
                }
                catch (Exception ex) {
                    webElement.setName(oldName);
                    LoggerSingleton.logError((Throwable)ex);
                    MessageDialog.openError((Shell)this.parentShell, (String)GlobalMessageConstants.ERROR, (String)ComposerObjectRepositoryMessageConstants.HAND_ERROR_MSG_UNABLE_TO_RENAME_TEST_OBJECT);
                    return;
                }
                this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)webElementTreeEntity.getParent());
                this.eventBroker.post("TESTOBJECT/UPDATED", (Object)new Object[]{pk, webElement});
                this.eventBroker.post("EXPLORER/SET_SELECTED_ITEM", (Object)webElementTreeEntity);
            }
            catch (Exception e) {
                LoggerSingleton.logError((Throwable)e);
            }
        }
    }
}

