/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.handler;

import com.kms.katalon.composer.components.impl.event.EventServiceAdapter;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.objectrepository.dialog.FixBrokenTestObjectNotifyingDialog;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testcase.BrokenTestCaseSummary;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.repository.WebElementEntity;
import com.kms.katalon.objectspy.dialog.NewObjectSpyDialog;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class SpyObjectHandler {
    public static final String SHOULD_NOT_SHOW_FIX_BROKEN_TEST_OBJECT_DIALOG = "shouldNotShowFixBrokenTestObjectDialog";
    @Inject
    private IEventBroker eventBroker;
    private NewObjectSpyDialog objectSpyDialog;

    @PostConstruct
    public void registerAddToObjectSpyEvent() {
        this.eventBroker.subscribe("OBJECT_SPY/TEST_OBJECT_ADDED", (EventHandler)new EventServiceAdapter(){

            public void handleEvent(Event event) {
                SpyObjectHandler.this.openDialogAndAddObject(Display.getCurrent().getActiveShell(), this.getObjects(event));
            }
        });
        this.eventBroker.subscribe("OBJECT_SPY/WEB", new EventHandler(){

            public void handleEvent(Event event) {
                if (!SpyObjectHandler.this.canExecute()) {
                    return;
                }
                SpyObjectHandler.this.execute(Display.getCurrent().getActiveShell());
            }
        });
    }

    @Execute
    public void execute(@Named(value="activeShell") @Named(value="activeShell") Shell activeShell) {
        this.openDialogAndAddObject(activeShell, null);
    }

    private void openDialogAndAddObject(Shell activeShell, Object[] selectedObjects) {
        try {
            if (this.objectSpyDialog == null || this.objectSpyDialog.isDisposed()) {
                Shell shell = this.getShell(activeShell);
                this.objectSpyDialog = new NewObjectSpyDialog(shell, LoggerSingleton.getInstance().getLogger(), this.eventBroker);
                this.objectSpyDialog.setBlockOnOpen(false);
            } else {
                this.objectSpyDialog.getShell().forceActive();
            }
            this.objectSpyDialog.open();
            if (selectedObjects != null) {
                Object selectedObject = selectedObjects[0];
                if (selectedObject instanceof BrokenTestCaseSummary) {
                    BrokenTestCaseSummary brokenTestObjectSummary = (BrokenTestCaseSummary)selectedObject;
                    this.objectSpyDialog.openBrowserForFixingBrokenTestObject(brokenTestObjectSummary.getMhtml());
                    this.objectSpyDialog.addBrokenTestObject(brokenTestObjectSummary);
                } else {
                    this.objectSpyDialog.addObjectsFromObjectRepository(selectedObjects);
                }
            }
        }
        catch (Exception e) {
            if (this.objectSpyDialog != null) {
                this.objectSpyDialog.stop();
                this.objectSpyDialog.close();
            }
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
        }
    }

    private void showFixBrokenTestObjectDialog() {
        boolean shouldShowThisDialog;
        ScopedPreferenceStore store = PreferenceStoreManager.getPreferenceStore(this.getClass());
        boolean bl = shouldShowThisDialog = !store.getBoolean(SHOULD_NOT_SHOW_FIX_BROKEN_TEST_OBJECT_DIALOG);
        if (shouldShowThisDialog) {
            FixBrokenTestObjectNotifyingDialog dialog = new FixBrokenTestObjectNotifyingDialog(Display.getCurrent().getActiveShell());
            dialog.setBlockOnOpen(false);
            dialog.open();
        }
    }

    private Shell getShell(Shell activeShell) {
        String os = Platform.getOS();
        if ("win32".equals(os) || "linux".equals(os)) {
            return null;
        }
        Shell shell = new Shell();
        Rectangle activeShellSize = activeShell.getBounds();
        shell.setLocation((activeShellSize.width - shell.getBounds().width) / 2, (activeShellSize.height - shell.getBounds().height) / 2);
        return shell;
    }

    @CanExecute
    private boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    public static ITreeEntity getParentTreeEntity(Object[] selectedObjects) throws Exception {
        Object[] objectArray = selectedObjects;
        int n = selectedObjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof ITreeEntity) {
                if (((ITreeEntity)object).getObject() instanceof FolderEntity) {
                    FolderEntity folder = (FolderEntity)((ITreeEntity)object).getObject();
                    if (folder.getFolderType() == FolderEntity.FolderType.WEBELEMENT) {
                        return (ITreeEntity)object;
                    }
                } else if (((ITreeEntity)object).getObject() instanceof WebElementEntity) {
                    return ((ITreeEntity)object).getParent();
                }
            }
            ++n2;
        }
        return null;
    }
}

