/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.menu;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.menu.MenuFactory;
import com.kms.katalon.composer.objectrepository.constant.ComposerObjectRepositoryMessageConstants;
import com.kms.katalon.composer.objectrepository.handler.NewTestObjectHandler;
import com.kms.katalon.constants.helper.ConstantsHelper;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.entity.project.ProjectType;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.ui.di.AboutToShow;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MHandledMenuItem;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;

public class NewTestObjectPopupMenuContribution {
    private static final String NEW_TESTOBJECT_POPUP_MENUITEM_LABEL = ComposerObjectRepositoryMessageConstants.MENU_CONTEXT_NEW_TEST_OBJ;
    private static final String NEW_TESTOBJECT_COMMAND_ID = "com.kms.katalon.composer.objectrepository.command.add";
    @Inject
    private ECommandService commandService;
    @Inject
    private ESelectionService selectionService;

    @Inject
    public void init() {
        this.selectionService.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(MPart part, Object selection) {
                if (part.getElementId().equals("com.kms.katalon.composer.part.explorer")) {
                    NewTestObjectPopupMenuContribution.this.selectionService.setSelection(null);
                    NewTestObjectPopupMenuContribution.this.selectionService.setSelection(selection);
                }
            }
        });
    }

    @AboutToShow
    public void aboutToShow(List<MMenuElement> menuItems) {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        if (project.getType() == ProjectType.WEBSERVICE) {
            return;
        }
        try {
            MHandledMenuItem newTestObjectPopupMenuItem;
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            if (selectedObjects == null) {
                return;
            }
            if (NewTestObjectHandler.getParentTreeEntity(selectedObjects) != null && (newTestObjectPopupMenuItem = MenuFactory.createPopupMenuItem((ParameterizedCommand)this.commandService.createCommand(NEW_TESTOBJECT_COMMAND_ID, null), (String)NEW_TESTOBJECT_POPUP_MENUITEM_LABEL, (String)ConstantsHelper.getApplicationURI())) != null) {
                menuItems.add((MMenuElement)newTestObjectPopupMenuItem);
            }
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }
}

