/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.objectrepository.provider;

import com.kms.katalon.composer.objectrepository.view.ObjectPropertyTableRow;
import com.kms.katalon.entity.repository.WebElementPropertyEntity;
import java.util.Iterator;
import java.util.List;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class ObjectPropetiesTableViewer
extends TableViewer {
    private IEventBroker eventBroker;
    private List<WebElementPropertyEntity> data;
    boolean isSelectedAll;
    private Table propertyTable = this.getTable();

    public ObjectPropetiesTableViewer(Composite parent, int style, IEventBroker eventBroker) {
        super(parent, style);
        this.eventBroker = eventBroker;
    }

    public void setInput(List<WebElementPropertyEntity> data) {
        this.data = data;
        super.setInput(data);
        this.isSelectedAll = true;
        for (WebElementPropertyEntity object : data) {
            WebElementPropertyEntity pro = object;
            if (pro.getIsSelected().booleanValue()) continue;
            this.isSelectedAll = false;
        }
        this.eventBroker.post("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER", (Object)this);
    }

    public void addRow(WebElementPropertyEntity property) {
        this.data.add(property);
        this.refreshIsSelected();
        this.update(property, null);
        this.refresh();
        this.propertyTable.setSelection(this.data.size() - 1);
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void addRows(List<WebElementPropertyEntity> props) {
        int lastIndex = this.data.size();
        this.data.addAll(props);
        this.refreshIsSelected();
        this.update(props, null);
        this.refresh();
        this.propertyTable.setSelection(lastIndex, this.data.size() - 1);
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void addRowsWithPosition(List<ObjectPropertyTableRow> props) {
        for (ObjectPropertyTableRow row : props) {
            this.data.add(row.getPosition(), row.getWebElementPropertyEntity());
        }
        this.refreshIsSelected();
        this.refresh();
        this.propertyTable.deselectAll();
        for (ObjectPropertyTableRow row : props) {
            this.propertyTable.select(row.getPosition());
        }
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void deleteRows(List<WebElementPropertyEntity> properties) {
        this.data.removeAll(properties);
        this.refreshIsSelected();
        this.refresh();
        this.propertyTable.deselectAll();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void deleteRow(WebElementPropertyEntity property) {
        this.data.remove(property);
        this.refreshIsSelected();
        this.refresh();
        this.propertyTable.deselectAll();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void clear() {
        this.data.clear();
        this.refreshIsSelected();
        this.refresh();
        this.eventBroker.post("OBJECT/UPDATE_DIRTY", (Object)this);
    }

    public void setSelectedAll() {
        this.isSelectedAll = !this.isSelectedAll;
        Iterator<WebElementPropertyEntity> iterator = this.data.iterator();
        while (iterator.hasNext()) {
            WebElementPropertyEntity o;
            WebElementPropertyEntity pro = o = iterator.next();
            pro.setIsSelected(Boolean.valueOf(this.isSelectedAll));
        }
        this.refresh();
        this.eventBroker.post("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER", (Object)this);
    }

    public boolean getIsSelectedAll() {
        return this.isSelectedAll;
    }

    public void refreshIsSelected() {
        boolean check = true;
        for (WebElementPropertyEntity object : this.data) {
            WebElementPropertyEntity pro = object;
            if (pro.getIsSelected().booleanValue()) continue;
            check = false;
            break;
        }
        if (check != this.isSelectedAll) {
            this.isSelectedAll = check;
            this.eventBroker.post("OBJECT/UPDATE_IS_SELECTED_COLUMN_HEADER", (Object)this);
        }
    }

    public List<WebElementPropertyEntity> getInput() {
        return this.data;
    }
}

