/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.application;

import com.kms.katalon.application.ApplicationStarter;
import com.kms.katalon.application.utils.ActivationInfoCollector;
import com.kms.katalon.console.application.ConsoleMain;
import com.kms.katalon.console.constants.ConsoleMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.event.EventBusSingleton;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.logging.LogUtil;
import com.kms.katalon.tracking.core.TrackingManager;
import com.kms.katalon.tracking.service.Trackings;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eventbus.EventBus;

public class ConsoleApplicationStarter
implements ApplicationStarter {
    private void init() {
        EventBusSingleton.getInstance().setEventBus(EventBus.builder().installDefaultEventBus());
        int trackingTime = TrackingManager.getInstance().getTrackingTime();
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(() -> Trackings.trackProjectStatistics((ProjectEntity)ProjectController.getInstance().getCurrentProject(), (!ActivationInfoCollector.isActivated() ? 1 : 0) != 0, (String)"console"), trackingTime, trackingTime, TimeUnit.SECONDS);
    }

    public int start(String[] arguments) {
        System.setProperty("eclipse.exitdata", "");
        try {
            this.init();
            return ConsoleMain.launch(arguments);
        }
        catch (Exception e) {
            LogUtil.printAndLogError((Throwable)e, (String)ConsoleMessageConstants.ERR_CONSOLE_MODE);
            return 2;
        }
    }

    public void stop() {
    }
}

