/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.kms.katalon.application.utils.ApplicationInfo;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.core.util.FailedTestThreshold;
import com.kms.katalon.execution.console.ApplicationConfigOptions;
import com.kms.katalon.execution.console.entity.ConsoleOption;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.handler.ApiKeyOnPremiseHandler;
import com.kms.katalon.logging.LogUtil;
import joptsimple.OptionSet;
import org.apache.commons.lang3.StringUtils;

public class ArgumentOptionsHandler {
    private static ArgumentOptionsHandler _instance;
    private OptionSet options;

    private ArgumentOptionsHandler() {
    }

    public static ArgumentOptionsHandler getInstance() {
        if (_instance == null) {
            _instance = new ArgumentOptionsHandler();
        }
        return _instance;
    }

    public boolean isRunWithTestCloudBrowser() {
        String browserType = this.getBrowserType();
        return browserType.equalsIgnoreCase(GlobalMessageConstants.TESTCLOUD_NAME);
    }

    public String getBrowserType() {
        String browserType = "";
        if (this.options.has("browserType")) {
            browserType = String.valueOf(this.options.valueOf("browserType"));
        }
        return browserType;
    }

    public boolean isRunningTestSuite() {
        return StringUtils.isNotBlank((CharSequence)this.getTestSuitePath());
    }

    public String getTestSuitePath() {
        String testSuitePath = "";
        if (this.options.has("testSuitePath")) {
            testSuitePath = String.valueOf(this.options.valueOf("testSuitePath"));
        }
        return testSuitePath;
    }

    public String getAdminServerUrl() {
        String adminServerUrl = null;
        if (this.options.has("serverUrl")) {
            adminServerUrl = String.valueOf(this.options.valueOf("serverUrl"));
        }
        if (this.options.has("serverURL")) {
            adminServerUrl = String.valueOf(this.options.valueOf("serverURL"));
        }
        if (!StringUtils.isEmpty((CharSequence)adminServerUrl)) {
            ApplicationInfo.setAdminServer((String)adminServerUrl);
        }
        return adminServerUrl;
    }

    public void prepareApplicationConfiguration(ApplicationConfigOptions applicationConfigOptions) throws Exception {
        for (ConsoleOption opt : applicationConfigOptions.getConsoleOptionList()) {
            String optionName = opt.getOption();
            if (!this.options.hasArgument(optionName)) continue;
            applicationConfigOptions.setArgumentValue(opt, String.valueOf(this.options.valueOf(optionName)));
        }
    }

    public void validateOption() {
        if (this.options.has("maxFailedTests")) {
            try {
                int maxFailedTestValue = Integer.valueOf(this.options.valueOf("maxFailedTests").toString().replaceAll("'", ""));
                if (maxFailedTestValue <= 0) {
                    maxFailedTestValue = -1;
                    LogUtil.printErrorLine((String)ExecutionMessageConstants.MSG_ERR_MAX_FAILED_TEST_INVALID_INPUT);
                } else {
                    this.saveFailedTestThreshold(maxFailedTestValue);
                }
            }
            catch (NumberFormatException numberFormatException) {
                LogUtil.printErrorLine((String)ExecutionMessageConstants.MSG_ERR_MAX_FAILED_TEST_INVALID_INPUT);
            }
        }
        if (this.options.has("delayBetweenInstances")) {
            this.delayBetweenInstanceErrorLogInfo();
        }
    }

    public String getApiKeyValue() {
        String apiKeyValue = null;
        if (this.options.has("apiKey")) {
            apiKeyValue = String.valueOf(this.options.valueOf("apiKey"));
        }
        if (this.options.has("apikey")) {
            apiKeyValue = String.valueOf(this.options.valueOf("apikey"));
        }
        return apiKeyValue;
    }

    public String getOrganizationId() {
        String organizationId = null;
        if (this.options.has("orgId")) {
            organizationId = String.valueOf(this.options.valueOf("orgId"));
        }
        if (this.options.has("orgID")) {
            organizationId = String.valueOf(this.options.valueOf("orgID"));
        }
        return organizationId;
    }

    public String getApiKeyOnpremiseValue() {
        String apiKeyOnPremiseValue = null;
        if (this.options.has("apiKeyOnPremise")) {
            apiKeyOnPremiseValue = String.valueOf(this.options.valueOf("apiKeyOnPremise"));
        }
        if (this.options.has("apiKeyOP")) {
            apiKeyOnPremiseValue = String.valueOf(this.options.valueOf("apiKeyOP"));
        }
        ApiKeyOnPremiseHandler.setApiKeyOnPremiseToProject((String)apiKeyOnPremiseValue);
        return apiKeyOnPremiseValue;
    }

    public boolean getKatalonLicense() {
        if (this.options.has("licenseRelease")) {
            return Boolean.valueOf(this.options.valueOf("licenseRelease").toString());
        }
        return false;
    }

    private void saveFailedTestThreshold(int numOfFailedTests) {
        FailedTestThreshold instance = FailedTestThreshold.getInstance();
        instance.setThreshold(numOfFailedTests);
        instance.setThresholdAvailable(true);
    }

    private void delayBetweenInstanceErrorLogInfo() {
        try {
            int delay = Integer.parseInt(this.options.valueOf("delayBetweenInstances").toString());
            if (delay < 0 || delay > 999) {
                LogUtil.logInfo((String)ExecutionMessageConstants.MSG_DELAY_BETWEEN_INSTANCE_INVALID);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LogUtil.logInfo((String)ExecutionMessageConstants.MSG_DELAY_BETWEEN_INSTANCE_INVALID);
        }
    }

    public String getTestOpsServerUrl() {
        String testOpsServerUrl = null;
        if (this.options.has("testOps.serverUrl")) {
            testOpsServerUrl = String.valueOf(this.options.valueOf("testOps.serverUrl"));
        }
        if (StringUtils.isNotBlank(testOpsServerUrl)) {
            ApplicationInfo.setTestOpsServer(testOpsServerUrl);
        }
        return testOpsServerUrl;
    }

    public boolean useTestOpsServerUrlArgument() {
        return StringUtils.isNotBlank((CharSequence)this.getTestOpsServerUrl());
    }

    public OptionSet getOptions() {
        return this.options;
    }

    public void setOptions(OptionSet options) {
        this.options = options;
    }
}

