/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.artifact.core.util;

import com.kms.katalon.composer.artifact.core.FileCompressionException;
import java.io.File;
import net.lingala.zip4j.core.ZipFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.model.ZipParameters;

public class ZipUtil {
    public static ZipFile getZipFile(File zipFile, File folderToZip) throws FileCompressionException {
        if (zipFile.exists()) {
            zipFile.delete();
        }
        try {
            ZipFile returnedZipFile = new ZipFile(zipFile);
            ZipParameters parameters = new ZipParameters();
            parameters.setCompressionMethod(8);
            parameters.setCompressionLevel(5);
            returnedZipFile.addFolder(folderToZip.getAbsolutePath(), parameters);
            return returnedZipFile;
        }
        catch (ZipException e) {
            throw new FileCompressionException("Cannot zip folder: " + folderToZip.getAbsolutePath(), e);
        }
    }

    public static void extractAll(File file, File destinationFolder) throws FileCompressionException {
        try {
            ZipFile zipFile = new ZipFile(file.getAbsolutePath());
            zipFile.extractAll(destinationFolder.getAbsolutePath());
        }
        catch (ZipException e) {
            throw new FileCompressionException("Cannot extract file: " + file.getAbsolutePath(), e);
        }
    }
}

