/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.driver;

import com.kms.katalon.core.mobile.driver.AppiumDriverSession;
import io.appium.java_client.AppiumDriver;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.openqa.selenium.WebElement;

public class AppiumSessionCollector {
    private List<AppiumDriverSession> sessions = new LinkedList<AppiumDriverSession>();
    private static AppiumSessionCollector instance;

    private AppiumSessionCollector() {
    }

    private static AppiumSessionCollector getInstance() {
        if (instance == null) {
            instance = new AppiumSessionCollector();
            AppiumSessionCollector.instance.sessions = new LinkedList<AppiumDriverSession>();
        }
        return instance;
    }

    public static AppiumDriverSession addSession(AppiumDriverSession session) {
        AppiumSessionCollector.getInstance().sessions.add(session);
        return session;
    }

    public static AppiumDriverSession addSession(AppiumDriver<? extends WebElement> driver) {
        AppiumDriverSession session = new AppiumDriverSession(driver);
        AppiumSessionCollector.getInstance().sessions.add(session);
        return session;
    }

    public static AppiumDriverSession getSession(AppiumDriver<? extends WebElement> driver) {
        Optional<AppiumDriverSession> session = AppiumSessionCollector.ofDriver(driver);
        if (session.isPresent()) {
            return session.get();
        }
        return AppiumSessionCollector.addSession(driver);
    }

    public static void removeSession(AppiumDriver<? extends WebElement> driver) {
        Optional<AppiumDriverSession> session = AppiumSessionCollector.ofDriver(driver);
        if (session.isPresent()) {
            AppiumSessionCollector.removeSession(session.get());
        }
    }

    public static Optional<AppiumDriverSession> ofDriver(AppiumDriver<? extends WebElement> driver) {
        return AppiumSessionCollector.getInstance().sessions.stream().filter(s -> s.getDriver() == driver).findFirst();
    }

    public static void removeSession(AppiumDriverSession session) {
        AppiumSessionCollector.getInstance().sessions.remove(session);
    }

    public static int getSessionCount() {
        return AppiumSessionCollector.getInstance().sessions.size();
    }
}

