/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.helper;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.exception.MobileException;
import com.kms.katalon.core.mobile.helper.DeviceScreenInfo;
import com.kms.katalon.core.mobile.helper.DeviceViewPortRect;
import com.kms.katalon.core.mobile.helper.StatusBarSize;
import com.kms.katalon.core.util.internal.JsonUtil;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;
import java.text.MessageFormat;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;

public final class IOSHelper {
    private static final KeywordLogger logger = KeywordLogger.getInstance(IOSHelper.class);

    private IOSHelper() {
    }

    public static int getStatusBarHeight(AppiumDriver<? extends WebElement> driver) {
        int statusBarHeight = 0;
        IOSDriver iosDriver = (IOSDriver)driver;
        try {
            DeviceScreenInfo deviceScreenInfo = IOSHelper.getDeviceScreenInfo((AppiumDriver<? extends WebElement>)iosDriver);
            StatusBarSize statusBarSize = deviceScreenInfo.getStatusBarSize();
            statusBarHeight = (int)((float)statusBarSize.getHeight() * deviceScreenInfo.getScale());
        }
        catch (Exception e) {
            logger.logInfo(String.valueOf(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO) + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect = IOSHelper.getDeviceViewPortRect((AppiumDriver<? extends WebElement>)iosDriver);
                int scale = deviceViewPortRect.getWidth() / screenSize.getWidth();
                statusBarHeight = deviceViewPortRect.getTop() / scale;
            }
            catch (Exception ex) {
                logger.logInfo(String.valueOf(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT) + " " + ex.getMessage());
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "Screenshot"));
            }
        }
        return statusBarHeight;
    }

    public static float getScaleFactor(AppiumDriver<? extends WebElement> driver) {
        float scaleFactor = 1.0f;
        try {
            DeviceScreenInfo deviceScreenInfo = IOSHelper.getDeviceScreenInfo(driver);
            scaleFactor = deviceScreenInfo.getScale();
        }
        catch (Exception e) {
            logger.logInfo(String.valueOf(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO) + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect = IOSHelper.getDeviceViewPortRect(driver);
                scaleFactor = deviceViewPortRect.getWidth() / screenSize.getWidth();
            }
            catch (Exception exception) {
                logger.logInfo(String.valueOf(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT) + " " + e.getMessage());
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_SCALE_FACTOR);
            }
        }
        return scaleFactor;
    }

    public static String getActiveAppBundleIdFromSession(AppiumDriver<? extends WebElement> driver) {
        return (String)AppiumSessionCollector.getSession(driver).getProperties().get("iosBundleId");
    }

    private static DeviceScreenInfo getDeviceScreenInfo(AppiumDriver<? extends WebElement> driver) throws MobileException {
        IOSDriver iosDriver = (IOSDriver)driver;
        Object info = iosDriver.executeScript("mobile: deviceScreenInfo", new Object[0]);
        if (info == null) {
            throw new MobileException("The raw data is null.");
        }
        DeviceScreenInfo deviceScreenInfo = (DeviceScreenInfo)JsonUtil.fromJson((String)info.toString(), DeviceScreenInfo.class);
        if (deviceScreenInfo == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }
        return deviceScreenInfo;
    }

    private static DeviceViewPortRect getDeviceViewPortRect(AppiumDriver<? extends WebElement> driver) throws MobileException {
        IOSDriver iosDriver = (IOSDriver)driver;
        Object rect = iosDriver.executeScript("mobile: viewportRect", new Object[0]);
        if (rect == null) {
            throw new MobileException("The raw data is null.");
        }
        DeviceViewPortRect deviceViewPortRect = (DeviceViewPortRect)JsonUtil.fromJson((String)rect.toString(), DeviceViewPortRect.class);
        if (deviceViewPortRect == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }
        return deviceViewPortRect;
    }
}

