/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.DecompileAction;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.ClassUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.UIUtil;

public class SetupRunnable
implements Runnable {
    @Override
    public void run() {
        try {
            if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) {
                Display.getDefault().timerExec(1000, new Runnable(){

                    @Override
                    public void run() {
                        SetupRunnable.this.run();
                    }
                });
            } else {
                this.checkClassFileAssociation();
                this.setupPartListener();
            }
        }
        catch (Throwable e) {
            Logger.debug(e);
        }
    }

    private void setupPartListener() {
        final IPerspectiveListener perspectiveListener = new IPerspectiveListener(){

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (UIUtil.isDebugPerspective()) {
                    new DecompileAction().run();
                }
            }
        };
        final IPartListener partListener = new IPartListener(){

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partClosed(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
                if (part instanceof JavaDecompilerClassFileEditor) {
                    String code = ((JavaDecompilerClassFileEditor)part).getViewer().getDocument().get();
                    if (ClassUtil.isDebug() != JavaDecompilerClassFileEditor.isDebug(code)) {
                        ((JavaDecompilerClassFileEditor)part).doSetInput(false);
                    }
                }
            }

            public void partActivated(IWorkbenchPart part) {
            }
        };
        final IPageListener pageListener = new IPageListener(){

            public void pageOpened(IWorkbenchPage page) {
                page.removePartListener(partListener);
                page.addPartListener(partListener);
            }

            public void pageClosed(IWorkbenchPage page) {
                page.removePartListener(partListener);
            }

            public void pageActivated(IWorkbenchPage page) {
                page.removePartListener(partListener);
                page.addPartListener(partListener);
            }
        };
        IWindowListener windowListener = new IWindowListener(){

            public void windowOpened(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                window.addPageListener(pageListener);
                window.removePerspectiveListener(perspectiveListener);
                window.addPerspectiveListener(perspectiveListener);
                IWorkbenchPage[] pages = window.getPages();
                if (pages != null) {
                    int i = 0;
                    while (i < pages.length) {
                        pages[i].removePartListener(partListener);
                        pages[i].addPartListener(partListener);
                        ++i;
                    }
                }
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                window.removePerspectiveListener(perspectiveListener);
            }

            public void windowClosed(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                window.removePerspectiveListener(perspectiveListener);
            }

            public void windowActivated(IWorkbenchWindow window) {
                window.removePageListener(pageListener);
                window.addPageListener(pageListener);
                window.removePerspectiveListener(perspectiveListener);
                window.addPerspectiveListener(perspectiveListener);
                IWorkbenchPage[] pages = window.getPages();
                if (pages != null) {
                    int i = 0;
                    while (i < pages.length) {
                        pages[i].removePartListener(partListener);
                        pages[i].addPartListener(partListener);
                        ++i;
                    }
                }
            }
        };
        if (PlatformUI.getWorkbench() == null) {
            return;
        }
        PlatformUI.getWorkbench().removeWindowListener(windowListener);
        PlatformUI.getWorkbench().addWindowListener(windowListener);
        if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null) {
            return;
        }
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePageListener(pageListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPageListener(pageListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(perspectiveListener);
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(perspectiveListener);
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page == null) {
            return;
        }
        page.removePartListener(partListener);
        page.addPartListener(partListener);
    }

    private void checkClassFileAssociation() {
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        if (prefs.getBoolean("org.sf.feeling.decompiler.default_editor")) {
            this.updateClassDefaultEditor();
            IPreferenceStore store = WorkbenchPlugin.getDefault().getPreferenceStore();
            store.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("resourcetypes".equals(event.getProperty())) {
                        SetupRunnable.this.updateClassDefaultEditor();
                    }
                }
            });
        }
    }

    protected void updateClassDefaultEditor() {
        EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IFileEditorMapping[] mappings = registry.getFileEditorMappings();
        IFileEditorMapping classNoSource = null;
        IFileEditorMapping classPlain = null;
        int i = 0;
        while (i < mappings.length) {
            IFileEditorMapping mapping = mappings[i];
            if (mapping.getExtension().equals("class without source")) {
                classNoSource = mapping;
            } else if (mapping.getExtension().equals("class")) {
                classPlain = mapping;
            }
            ++i;
        }
        IFileEditorMapping[] classMappings = new IFileEditorMapping[]{classNoSource, classPlain};
        boolean needUpdate = this.checkDefaultEditor(classMappings);
        if (needUpdate) {
            int i2 = 0;
            while (i2 < classMappings.length) {
                IFileEditorMapping mapping = classMappings[i2];
                int j = 0;
                while (j < mapping.getEditors().length) {
                    IEditorDescriptor editor = mapping.getEditors()[j];
                    if (editor.getId().equals("org.sf.feeling.decompiler.ClassFileEditor")) {
                        try {
                            ReflectionUtils.invokeMethod((Object)mapping, "setDefaultEditor", new Class[]{Class.forName("org.eclipse.ui.IEditorDescriptor")}, new Object[]{editor});
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                        try {
                            ReflectionUtils.invokeMethod((Object)mapping, "setDefaultEditor", new Class[]{Class.forName("org.eclipse.ui.internal.registry.EditorDescriptor")}, new Object[]{editor});
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                ++i2;
            }
            registry.setFileEditorMappings((FileEditorMapping[])mappings);
            registry.saveAssociations();
        }
    }

    protected boolean checkDefaultEditor(IFileEditorMapping[] classMappings) {
        int i = 0;
        while (i < classMappings.length) {
            IFileEditorMapping mapping = classMappings[i];
            if (mapping.getDefaultEditor() != null && !mapping.getDefaultEditor().getId().equals("org.sf.feeling.decompiler.ClassFileEditor")) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

