/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.Arrays;
import org.eclipse.core.runtime.PerformanceStats;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.i18n.Messages;

public class DecompileActionGroup
extends ActionGroup {
    public static final String MENU_MAIN = "org.sf.feeling.decompiler.main";
    public static final String MENU_SOURCE = "org.sf.feeling.decompiler.source";
    private static final String PERF_DECOMPILE_ACTION_GROUP = "org.sf.feeling.decompiler/perf/DecompileActionGroup";
    private static final String QUICK_MENU_MAIN = "org.sf.feeling.decompiler.main.quickMenu";
    private static final String QUICK_MENU_SOURCE = "org.sf.feeling.decompiler.source.quickMenu";
    private String fGroupName = "group.reorganize";
    private JavaDecompilerClassFileEditor fEditor;

    public DecompileActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite(), null);
    }

    public DecompileActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite(), null);
    }

    public DecompileActionGroup(JavaDecompilerClassFileEditor editor, String groupName, boolean binary) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_DECOMPILE_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        this.fEditor = editor;
        this.fGroupName = groupName;
        stats.endRun();
    }

    public DecompileActionGroup(IWorkbenchSite site, ISelectionProvider selectionProvider) {
        PerformanceStats stats = PerformanceStats.getStats((String)PERF_DECOMPILE_ACTION_GROUP, (Object)((Object)this));
        stats.startRun();
        stats.endRun();
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        this.addSourceSubmenu(menu);
        this.addMainSubmenu(menu);
    }

    public void dispose() {
        super.dispose();
    }

    private void addMainSubmenu(IMenuManager menu) {
        ITypeRoot element;
        MenuManager mainSubmenu = new MenuManager(Messages.getString("JavaDecompilerActionBarContributor.Menu.Decompiler"), MENU_MAIN);
        mainSubmenu.setActionDefinitionId(QUICK_MENU_MAIN);
        if (this.fEditor != null && (element = this.getEditorInput()) != null && ActionUtil.isOnBuildPath((IJavaElement)element)) {
            mainSubmenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    DecompileActionGroup.this.showMenu(manager);
                }
            });
            menu.appendToGroup(this.fGroupName, (IContributionItem)new Separator());
            menu.appendToGroup(this.fGroupName, (IContributionItem)mainSubmenu);
            menu.appendToGroup(this.fGroupName, (IContributionItem)new Separator());
        }
    }

    private void addSourceSubmenu(IMenuManager menu) {
        ITypeRoot element;
        MenuManager sourceSubmenu = new MenuManager(Messages.getString("JavaDecompilerActionBarContributor.Menu.Source"), MENU_SOURCE);
        sourceSubmenu.setActionDefinitionId(QUICK_MENU_SOURCE);
        if (this.fEditor != null && (element = this.getEditorInput()) != null && ActionUtil.isOnBuildPath((IJavaElement)element)) {
            sourceSubmenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    DecompileActionGroup.this.showMenu(manager);
                }
            });
            menu.appendToGroup(this.fGroupName, (IContributionItem)new Separator());
            menu.appendToGroup(this.fGroupName, (IContributionItem)sourceSubmenu);
            menu.appendToGroup(this.fGroupName, (IContributionItem)new Separator());
        }
    }

    private void showMenu(IMenuManager submenu) {
        for (IContributionItem item : Arrays.asList(submenu.getItems())) {
            IAction action;
            if (!(item instanceof ActionContributionItem) || !((action = ((ActionContributionItem)item).getAction()) instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    private ITypeRoot getEditorInput() {
        return JavaUI.getEditorInputTypeRoot((IEditorInput)this.fEditor.getEditorInput());
    }
}

