/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.i18n.Messages;
import org.sf.feeling.decompiler.util.DecompileUtil;
import org.sf.feeling.decompiler.util.FileUtil;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.UIUtil;

public class ExportSourceAction
extends Action {
    private List selection = null;
    private boolean isFlat = false;

    public ExportSourceAction(List selection) {
        super(Messages.getString("ExportSourceAction.Action.Text"));
        this.setImageDescriptor(JavaDecompilerPlugin.getImageDescriptor("icons/etool16/export_wiz.png"));
        this.setDisabledImageDescriptor(JavaDecompilerPlugin.getImageDescriptor("icons/dtool16/export_wiz.png"));
        this.selection = selection;
        this.isFlat = UIUtil.isPackageFlat();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        IPreferenceStore prefs = JavaDecompilerPlugin.getDefault().getPreferenceStore();
        String decompilerType = prefs.getString("org.sf.feeling.decompiler.type");
        boolean reuseBuf = prefs.getBoolean("org.sf.feeling.decompiler.reusebuff");
        boolean always = prefs.getBoolean("org.sf.feeling.decompiler.alwaysuse");
        Object firstElement = this.selection.get(0);
        if (this.selection.size() == 1 && firstElement instanceof IClassFile) {
            IClassFile cf = (IClassFile)firstElement;
            this.exportClass(decompilerType, reuseBuf, always, cf);
            return;
        } else if (this.selection.size() == 1 && firstElement instanceof IPackageFragmentRoot) {
            IPackageFragmentRoot root = (IPackageFragmentRoot)firstElement;
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 0x10002000);
            String fileName = root.getElementName();
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                fileName = fileName.substring(0, index);
            }
            dialog.setFileName(String.valueOf(fileName) + "-src");
            dialog.setFilterExtensions(new String[]{"*.zip"});
            String file = dialog.open();
            if (file == null || file.trim().length() <= 0) return;
            String projectFile = file.trim();
            try {
                IJavaElement[] children = root.getChildren();
                this.exportPackagesSource(decompilerType, reuseBuf, always, projectFile, children);
                return;
            }
            catch (CoreException e) {
                ExceptionHandler.handle((CoreException)e, (String)Messages.getString("ExportSourceAction.ErrorDialog.Title"), (String)Messages.getString("ExportSourceAction.ErrorDialog.Message.CollectClassInfo"));
            }
            return;
        } else {
            IPackageFragmentRoot root = null;
            if (firstElement instanceof IClassFile) {
                root = (IPackageFragmentRoot)((IClassFile)firstElement).getParent().getParent();
            } else if (firstElement instanceof IPackageFragment) {
                root = (IPackageFragmentRoot)((IPackageFragment)firstElement).getParent();
            }
            if (root == null) {
                return;
            }
            FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 0x10002000);
            String fileName = root.getElementName();
            int index = fileName.lastIndexOf(46);
            if (index != -1) {
                fileName = fileName.substring(0, index);
            }
            dialog.setFileName(String.valueOf(fileName) + "-src");
            dialog.setFilterExtensions(new String[]{"*.zip"});
            String file = dialog.open();
            if (file == null || file.trim().length() <= 0) return;
            String projectFile = file.trim();
            this.exportPackagesSource(decompilerType, reuseBuf, always, projectFile, this.selection.toArray(new IJavaElement[0]));
        }
    }

    private void exportPackagesSource(final String decompilerType, final boolean reuseBuf, final boolean always, final String projectFile, final IJavaElement[] children) {
        try {
            final ArrayList exceptions = new ArrayList();
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell());
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    ExportSourceAction.this.exportPackageSources(monitor, decompilerType, reuseBuf, always, projectFile, children, exceptions);
                    File workingDir = new File(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd"));
                    if (workingDir != null && workingDir.exists()) {
                        try {
                            FileUtil.deleteDirectory(null, workingDir, 0);
                        }
                        catch (IOException e) {
                            Logger.debug(e);
                        }
                    }
                }
            });
            if (dialog.getProgressMonitor().isCanceled()) {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ExportSourceAction.InfoDialog.Title"), (String)Messages.getString("ExportSourceAction.InfoDialog.Message.Canceled"));
            } else if (!exceptions.isEmpty()) {
                MultiStatus status = new MultiStatus("org.sf.feeling.decompiler", 2, exceptions.size() <= 1 ? Messages.getFormattedString("ExportSourceAction.WarningDialog.Message.Failed", new String[]{"" + exceptions.size()}) : Messages.getFormattedString("ExportSourceAction.WarningDialog.Message.Failed.Multi", new String[]{"" + exceptions.size()}), null){

                    public void add(IStatus status) {
                        super.add(status);
                        this.setSeverity(2);
                    }
                };
                int i = 0;
                while (i < exceptions.size()) {
                    Status exception = (Status)exceptions.get(i);
                    status.add((IStatus)exception);
                    ++i;
                }
                JavaDecompilerPlugin.getDefault().getLog().log((IStatus)status);
                ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ExportSourceAction.WarningDialog.Title"), (String)Messages.getString("ExportSourceAction.WarningDialog.Message.Success"), (IStatus)status);
            } else {
                MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ExportSourceAction.InfoDialog.Title"), (String)Messages.getString("ExportSourceAction.InfoDialog.Message.Success"));
            }
        }
        catch (Exception e) {
            Status status = new Status(4, "org.sf.feeling.decompiler", Messages.getString("ExportSourceAction.Status.Error.DecompileAndExport"), (Throwable)e);
            ExceptionHandler.handle((IStatus)status, (String)Messages.getString("ExportSourceAction.ErrorDialog.Title"), (String)status.getMessage());
        }
    }

    private void exportPackageSources(IProgressMonitor monitor, String decompilerType, boolean reuseBuf, boolean always, String projectFile, IJavaElement[] children, List exceptions) throws InvocationTargetException, InterruptedException {
        Status status;
        monitor.beginTask(Messages.getString("ExportSourceAction.Task.Begin"), 1000000);
        File workingDir = new File(String.valueOf(JavaDecompilerPlugin.getDefault().getPreferenceStore().getString("org.sf.feeling.decompiler.tempd")) + "/export/" + System.currentTimeMillis());
        HashMap classes = new HashMap();
        int i = 0;
        while (i < children.length) {
            if (monitor.isCanceled()) {
                return;
            }
            IJavaElement child = children[i];
            try {
                this.collectClasses(child, classes, monitor);
            }
            catch (JavaModelException e) {
                status = new Status(4, "org.sf.feeling.decompiler", Messages.getString("ExportSourceAction.Status.Error.CollectPackage"), (Throwable)e);
                exceptions.add(status);
            }
            ++i;
        }
        monitor.worked(20000);
        IPackageFragment[] pkgs = classes.keySet().toArray(new IPackageFragment[0]);
        int step = 880000 / pkgs.length;
        int i2 = 0;
        while (i2 < pkgs.length) {
            if (monitor.isCanceled()) {
                return;
            }
            IPackageFragment pkg = pkgs[i2];
            List clazzs = (List)classes.get(pkg);
            if (clazzs.size() == 0) {
                monitor.worked(step);
            } else {
                int total = 0;
                int classStep = step / clazzs.size();
                int j = 0;
                while (j < clazzs.size()) {
                    block21: {
                        block22: {
                            if (monitor.isCanceled()) {
                                return;
                            }
                            IJavaElement clazz = (IJavaElement)clazzs.get(j);
                            if (clazz instanceof IClassFile && clazz.getParent() instanceof IPackageFragment) {
                                String className = pkg.getElementName();
                                if (pkg.getElementName().length() > 0) {
                                    className = String.valueOf(className) + "." + clazz.getElementName();
                                }
                                monitor.subTask(className);
                                try {
                                    IClassFile cf = (IClassFile)clazz;
                                    if (cf.getElementName().indexOf(36) != -1) break block21;
                                    String result = DecompileUtil.decompile(cf, decompilerType, always, reuseBuf, true);
                                    if (result != null) {
                                        String packageName = pkg.getElementName().replace('.', '/');
                                        if (packageName.length() > 0) {
                                            packageName = String.valueOf(packageName) + "/";
                                        }
                                        FileUtil.writeToFile(new File(workingDir, String.valueOf(packageName) + cf.getElementName().replaceAll("\\..+", "") + ".java"), result);
                                        break block22;
                                    }
                                    Status status2 = new Status(4, "org.sf.feeling.decompiler", Messages.getFormattedString("ExportSourceAction.Status.Error.DecompileFailed", new String[]{className}));
                                    throw new CoreException((IStatus)status2);
                                }
                                catch (Exception e) {
                                    Status status3 = new Status(4, "org.sf.feeling.decompiler", Messages.getFormattedString("ExportSourceAction.Status.Error.DecompileFailed", new String[]{className}));
                                    exceptions.add(status3);
                                }
                            }
                        }
                        total += classStep;
                        monitor.worked(classStep);
                    }
                    ++j;
                }
                if (total < step) {
                    monitor.worked(step - total);
                }
            }
            ++i2;
        }
        try {
            int exportStep = 80000 / pkgs.length;
            monitor.setTaskName(Messages.getString("ExportSourceAction.Task.ExportSource"));
            monitor.subTask("");
            ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(projectFile)));
            zos.setLevel(1);
            FileUtil.recursiveZip(monitor, zos, workingDir, "", null, exportStep);
            monitor.subTask("");
            zos.close();
            int total = exportStep * pkgs.length;
            if (total < 80000) {
                monitor.worked(80000 - total);
            }
            int deleteStep = 20000 / pkgs.length;
            monitor.setTaskName(Messages.getString("ExportSourceAction.Task.Clean"));
            monitor.subTask("");
            FileUtil.deleteDirectory(monitor, workingDir.getParentFile(), deleteStep);
            total = deleteStep * pkgs.length;
            if (total < 20000) {
                monitor.worked(20000 - total);
            }
        }
        catch (Exception e) {
            status = new Status(4, "org.sf.feeling.decompiler", Messages.getString("ExportSourceAction.Status.Error.ExportFailed"), (Throwable)e);
            exceptions.add(status);
        }
    }

    private void collectClasses(IJavaElement element, Map classes, IProgressMonitor monitor) throws JavaModelException {
        if (element instanceof IPackageFragment) {
            int i;
            IJavaElement[] children;
            IPackageFragment pkg = (IPackageFragment)element;
            if (!classes.containsKey(pkg)) {
                monitor.subTask(pkg.getElementName());
                ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
                children = pkg.getChildren();
                i = 0;
                while (i < children.length) {
                    list.add(children[i]);
                    ++i;
                }
                classes.put(pkg, list);
            }
            if (!this.isFlat) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
                children = root.getChildren();
                i = 0;
                while (i < root.getChildren().length) {
                    IPackageFragment child = (IPackageFragment)children[i];
                    if (child.getElementName().startsWith(String.valueOf(pkg.getElementName()) + ".") && !classes.containsKey(child)) {
                        this.collectClasses((IJavaElement)child, classes, monitor);
                    }
                    ++i;
                }
            }
        } else if (element instanceof IClassFile) {
            IPackageFragment pkg = (IPackageFragment)((IClassFile)element).getParent();
            if (!classes.containsKey(pkg)) {
                monitor.subTask(pkg.getElementName());
                ArrayList<IJavaElement> list = new ArrayList<IJavaElement>();
                list.add(element);
                classes.put(pkg, list);
            } else {
                ((List)classes.get(pkg)).add(element);
            }
        }
    }

    private void exportClass(String decompilerType, boolean reuseBuf, boolean always, IClassFile cf) {
        FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 0x10002000);
        dialog.setFileName(cf.getElementName().replaceAll("\\..+", ""));
        dialog.setFilterExtensions(new String[]{"*.java"});
        String file = dialog.open();
        if (file != null && file.trim().length() > 0) {
            IPackageFragment pkg = (IPackageFragment)cf.getParent();
            String className = pkg.getElementName();
            if (pkg.getElementName().length() > 0) {
                className = String.valueOf(className) + "." + cf.getElementName();
            }
            String projectFile = file.trim();
            try {
                String result = DecompileUtil.decompile(cf, decompilerType, always, reuseBuf, true);
                if (result == null) {
                    Status status = new Status(4, "org.sf.feeling.decompiler", Messages.getFormattedString("ExportSourceAction.Status.Error.DecompileFailed", new String[]{className}));
                    throw new CoreException((IStatus)status);
                }
                FileUtil.writeToFile(new File(projectFile), result);
            }
            catch (CoreException e) {
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("ExportSourceAction.ErrorDialog.Title"), (String)Messages.getFormattedString("ExportSourceAction.Status.Error.DecompileFailed", new String[]{className}));
            }
        } else {
            return;
        }
    }

    public boolean isEnabled() {
        return this.selection != null;
    }
}

