/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.actions;

import java.util.List;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.actions.ByteCodeAction;
import org.sf.feeling.decompiler.actions.DebugModeAction;
import org.sf.feeling.decompiler.actions.DecompileWithFernFlowerAction;
import org.sf.feeling.decompiler.actions.DecompilerPeferenceAction;
import org.sf.feeling.decompiler.actions.DisassemblerAction;
import org.sf.feeling.decompiler.actions.ExportEditorSourceAction;
import org.sf.feeling.decompiler.actions.ExportSourceAction;
import org.sf.feeling.decompiler.actions.SourceCodeAction;
import org.sf.feeling.decompiler.editor.DecompilerType;
import org.sf.feeling.decompiler.util.UIUtil;

public class SubMenuCreator
implements IMenuCreator {
    private MenuManager dropDownMenuMgr;

    public Menu getMenu(Menu parent) {
        final Menu menu = new Menu(parent);
        this.fillMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                while (menu.getItemCount() > 0) {
                    menu.getItem(0).dispose();
                }
                SubMenuCreator.this.fillMenu(menu);
            }
        });
        return menu;
    }

    private void fillMenu(Menu menu) {
        MenuManager menuMgr = new MenuManager();
        boolean isAddFernFlower = false;
        int i = 0;
        while (i < DecompilerType.getDecompilerTypes().length) {
            if (DecompilerType.getDecompilerTypes()[i].compareToIgnoreCase("FernFlower") > 0 && !isAddFernFlower) {
                menuMgr.add((IAction)new DecompileWithFernFlowerAction());
                isAddFernFlower = true;
            }
            menuMgr.add((IAction)JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(DecompilerType.getDecompilerTypes()[i]).getDecompileAction());
            ++i;
        }
        if (!isAddFernFlower) {
            menuMgr.add((IAction)new DecompileWithFernFlowerAction());
        }
        IContributionItem[] items = menuMgr.getItems();
        int i2 = 0;
        while (i2 < items.length) {
            IContributionItem item;
            IContributionItem newItem = item = items[i2];
            if (item instanceof ActionContributionItem) {
                newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
            }
            newItem.fill(menu, -1);
            ++i2;
        }
    }

    public Menu getMenu(Control parent) {
        this.createDropDownMenuMgr();
        return this.dropDownMenuMgr.createContextMenu(parent);
    }

    public void dispose() {
        if (this.dropDownMenuMgr != null) {
            this.dropDownMenuMgr.dispose();
            this.dropDownMenuMgr = null;
        }
    }

    private void createDropDownMenuMgr() {
        if (this.dropDownMenuMgr == null) {
            this.dropDownMenuMgr = new MenuManager();
            boolean isAddFernFlower = false;
            int i = 0;
            while (i < DecompilerType.getDecompilerTypes().length) {
                if (DecompilerType.getDecompilerTypes()[i].compareToIgnoreCase("FernFlower") > 0 && !isAddFernFlower) {
                    this.dropDownMenuMgr.add((IAction)new DecompileWithFernFlowerAction());
                    isAddFernFlower = true;
                }
                this.dropDownMenuMgr.add((IAction)JavaDecompilerPlugin.getDefault().getDecompilerDescriptor(DecompilerType.getDecompilerTypes()[i]).getDecompileAction());
                ++i;
            }
            if (!isAddFernFlower) {
                this.dropDownMenuMgr.add((IAction)new DecompileWithFernFlowerAction());
            }
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IAction)new SourceCodeAction());
            this.dropDownMenuMgr.add((IAction)new ByteCodeAction());
            this.dropDownMenuMgr.add((IAction)new DisassemblerAction());
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IAction)new DebugModeAction());
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            List list = UIUtil.getExportSelections();
            if (list != null) {
                this.dropDownMenuMgr.add((IAction)new ExportSourceAction(list));
            } else {
                this.dropDownMenuMgr.add((IAction)new ExportEditorSourceAction());
            }
            this.dropDownMenuMgr.add((IContributionItem)new Separator());
            this.dropDownMenuMgr.add((IContributionItem)new PreferenceActionContributionItem((IAction)new DecompilerPeferenceAction()));
        }
    }

    class PreferenceActionContributionItem
    extends ActionContributionItem {
        public PreferenceActionContributionItem(IAction action) {
            super(action);
        }

        public boolean isEnabledAllowed() {
            return true;
        }
    }
}

