/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import com.drgarbage.asm.render.intf.IFieldSection;
import com.drgarbage.asm.render.intf.IInstructionLine;
import com.drgarbage.asm.render.intf.IMethodSection;
import com.drgarbage.bytecode.instructions.BranchInstruction;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.AbstractJavaScanner;
import org.eclipse.jdt.internal.ui.text.JavaCommentScanner;
import org.eclipse.jdt.internal.ui.text.JavaPresentationReconciler;
import org.eclipse.jdt.internal.ui.text.SingleTokenJavaScanner;
import org.eclipse.jdt.internal.ui.text.java.JavaDoubleClickSelector;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverDescriptor;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaEditorTextHoverProxy;
import org.eclipse.jdt.ui.text.IColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultTextDoubleClickStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ITextEditor;
import org.sf.feeling.decompiler.editor.DisassemblerDocumentProvider;
import org.sf.feeling.decompiler.editor.RenderedBytecodeScanner;

public class DisassemblerConfiguration
extends TextSourceViewerConfiguration {
    private AbstractJavaScanner fCodeScanner;
    private IColorManager fColorManager;
    private String fDocumentPartitioning;
    private JavaDoubleClickSelector fJavaDoubleClickSelector;
    private AbstractJavaScanner fMultilineCommentScanner;
    private AbstractJavaScanner fSinglelineCommentScanner;
    private AbstractJavaScanner fStringScanner;
    private ITextEditor fTextEditor;

    public DisassemblerConfiguration(IColorManager colorManager, IPreferenceStore preferenceStore, ITextEditor editor, String partitioning) {
        super(preferenceStore);
        this.fColorManager = colorManager;
        this.fTextEditor = editor;
        this.fDocumentPartitioning = partitioning;
        this.initializeScanners();
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = hoverDescs[i].getStateMask();
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        JavaEditorTextHoverDescriptor[] hoverDescs = JavaPlugin.getDefault().getJavaEditorTextHoverDescriptors();
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled() && hoverDescs[i].getStateMask() == stateMask) {
                return new JavaEditorTextHoverProxy(hoverDescs[i], (IEditorPart)this.fTextEditor);
            }
            ++i;
        }
        return null;
    }

    protected RuleBasedScanner getCodeScanner() {
        return this.fCodeScanner;
    }

    protected IColorManager getColorManager() {
        return this.fColorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character", "__java_javadoc"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        if (this.fDocumentPartitioning != null) {
            return this.fDocumentPartitioning;
        }
        return super.getConfiguredDocumentPartitioning(sourceViewer);
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if ("__java_multiline_comment".equals(contentType) || "__java_singleline_comment".equals(contentType)) {
            return new DefaultTextDoubleClickStrategy();
        }
        if (this.fJavaDoubleClickSelector == null) {
            this.fJavaDoubleClickSelector = new JavaDoubleClickSelector();
            this.fJavaDoubleClickSelector.setSourceVersion(this.fPreferenceStore.getString("org.eclipse.jdt.core.compiler.source"));
        }
        return this.fJavaDoubleClickSelector;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        return new IHyperlinkDetector[]{new ClassFileHyperlinkDetector(), new URLHyperlinkDetector()};
    }

    protected RuleBasedScanner getMultilineCommentScanner() {
        return this.fMultilineCommentScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        JavaPresentationReconciler reconciler = new JavaPresentationReconciler();
        reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getCodeScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getMultilineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_multiline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_multiline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getSinglelineCommentScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_singleline_comment");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_string");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_character");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getStringScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__java_javadoc");
        reconciler.setRepairer((IPresentationRepairer)dr, "__java_javadoc");
        return reconciler;
    }

    protected RuleBasedScanner getSinglelineCommentScanner() {
        return this.fSinglelineCommentScanner;
    }

    protected RuleBasedScanner getStringScanner() {
        return this.fStringScanner;
    }

    private void initializeScanners() {
        this.fCodeScanner = new RenderedBytecodeScanner(this.getColorManager(), this.fPreferenceStore);
        this.fMultilineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_multi_line_comment");
        this.fSinglelineCommentScanner = new JavaCommentScanner(this.getColorManager(), this.fPreferenceStore, "java_single_line_comment");
        this.fStringScanner = new SingleTokenJavaScanner(this.getColorManager(), this.fPreferenceStore, "java_string");
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fCodeScanner.affectsBehavior(event)) {
            this.fCodeScanner.adaptToPreferenceChange(event);
        }
        if (this.fMultilineCommentScanner.affectsBehavior(event)) {
            this.fMultilineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fSinglelineCommentScanner.affectsBehavior(event)) {
            this.fSinglelineCommentScanner.adaptToPreferenceChange(event);
        }
        if (this.fStringScanner.affectsBehavior(event)) {
            this.fStringScanner.adaptToPreferenceChange(event);
        }
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    protected Map<String, IAdaptable> getHyperlinkDetectorTargets(ISourceViewer sourceViewer) {
        Map targets = super.getHyperlinkDetectorTargets(sourceViewer);
        targets.put("org.eclipse.jdt.ui.javaCode", this.fTextEditor);
        return targets;
    }

    class ClassFileFieldLocalHyperLink
    implements IHyperlink {
        private IRegion region;
        private String text;
        private int lineNumber;

        public ClassFileFieldLocalHyperLink(IRegion region, String text, int lineNumber) {
            this.region = region;
            this.text = text;
            this.lineNumber = lineNumber;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return this.text;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            int elementLength;
            int elementIndex;
            int destOffset;
            DisassemblerDocumentProvider bdp = (DisassemblerDocumentProvider)DisassemblerConfiguration.this.fTextEditor.getDocumentProvider();
            IFieldSection field = bdp.getClassFileDocument().findFieldSection(this.text);
            IDocument document = DisassemblerConfiguration.this.fTextEditor.getDocumentProvider().getDocument((Object)DisassemblerConfiguration.this.fTextEditor.getEditorInput());
            try {
                destOffset = document.getLineOffset(field.getBytecodeDocumentLine());
                int destLength = document.getLineLength(field.getBytecodeDocumentLine());
                String lineString = document.get(destOffset, destLength);
                elementIndex = lineString.indexOf(" " + this.text + ";") + 1;
                elementLength = this.text.length();
            }
            catch (BadLocationException e) {
                return;
            }
            DisassemblerConfiguration.this.fTextEditor.selectAndReveal(destOffset + elementIndex, elementLength);
        }
    }

    class ClassFileHyperlinkDetector
    implements IHyperlinkDetector {
        ClassFileHyperlinkDetector() {
        }

        public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
            IDocument document = DisassemblerConfiguration.this.fTextEditor.getDocumentProvider().getDocument((Object)DisassemblerConfiguration.this.fTextEditor.getEditorInput());
            IRegion lineInfo = null;
            String lineText = null;
            int lineNumber = -1;
            try {
                lineInfo = document.getLineInformationOfOffset(region.getOffset());
                lineText = document.get(lineInfo.getOffset(), lineInfo.getLength());
                lineNumber = document.getLineOfOffset(region.getOffset());
            }
            catch (BadLocationException ex) {
                return null;
            }
            if (lineText.contains("goto") || lineText.contains("if")) {
                int begin = lineText.indexOf(" ", 7);
                int end = lineText.indexOf(";");
                if (end < 0 || begin < 0 || end == begin + 1 || region.getOffset() < lineInfo.getOffset() + begin + 1) {
                    return null;
                }
                String linkText = lineText.substring(begin + 1, end);
                Region r2 = new Region(lineInfo.getOffset() + begin + 1, linkText.length());
                return new IHyperlink[]{new ClassFileLocalHyperLink((IRegion)r2, linkText, lineNumber)};
            }
            if (lineText.contains("/* .")) {
                int begin = lineText.indexOf("/* .") + 2;
                int end = lineText.indexOf("*/") - 1;
                if (end < 0 || begin < 0 || end == begin + 1 || region.getOffset() < lineInfo.getOffset() + begin + 1) {
                    return null;
                }
                String linkText = lineText.substring(begin + 2, end);
                Region r2 = new Region(lineInfo.getOffset() + begin + 1, linkText.length());
                return new IHyperlink[]{new ClassFileFieldLocalHyperLink((IRegion)r2, linkText, lineNumber)};
            }
            return null;
        }
    }

    class ClassFileLocalHyperLink
    implements IHyperlink {
        private IRegion region;
        private String text;
        private int lineNumber;

        public ClassFileLocalHyperLink(IRegion region, String text, int lineNumber) {
            this.region = region;
            this.text = text;
            this.lineNumber = lineNumber;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return this.text;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            DisassemblerDocumentProvider bdp = (DisassemblerDocumentProvider)DisassemblerConfiguration.this.fTextEditor.getDocumentProvider();
            IMethodSection method = bdp.getClassFileDocument().findMethodSection(this.lineNumber);
            List instructions = method.getInstructionLines();
            int targetOffset = -1;
            for (IInstructionLine i : instructions) {
                if (i.getLine() != this.lineNumber || !(i.getInstruction() instanceof BranchInstruction)) continue;
                BranchInstruction bi = (BranchInstruction)i.getInstruction();
                targetOffset = bi.getBranchOffset() + bi.getOffset();
                break;
            }
            for (IInstructionLine i : instructions) {
                int destLength;
                int destOffset;
                if (i.getInstruction().getOffset() != targetOffset) continue;
                IDocument document = DisassemblerConfiguration.this.fTextEditor.getDocumentProvider().getDocument((Object)DisassemblerConfiguration.this.fTextEditor.getEditorInput());
                try {
                    destOffset = document.getLineOffset(i.getLine());
                    destLength = document.getLineLength(i.getLine());
                }
                catch (BadLocationException e) {
                    return;
                }
                DisassemblerConfiguration.this.fTextEditor.selectAndReveal(destOffset, destLength - 1);
                break;
            }
        }
    }
}

