/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.editor;

import java.util.Enumeration;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.swt.widgets.Display;
import org.sf.feeling.decompiler.editor.ClassFileSourceMap;
import org.sf.feeling.decompiler.editor.JavaDecompilerClassFileEditor;
import org.sf.feeling.decompiler.util.Logger;
import org.sf.feeling.decompiler.util.UIUtil;

public class JavaDecompilerBufferManager
extends BufferManager {
    public static void closeDecompilerBuffers(boolean all) {
        BufferManager manager = BufferManager.getDefaultBufferManager();
        if (manager instanceof JavaDecompilerBufferManager) {
            Enumeration enumeration = manager.getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                IBuffer buffer = (IBuffer)enumeration.nextElement();
                ((JavaDecompilerBufferManager)manager).removeBuffer(buffer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaDecompilerBufferManager(BufferManager manager) {
        Class<BufferManager> clazz = BufferManager.class;
        synchronized (BufferManager.class) {
            Enumeration enumeration = manager.getOpenBuffers();
            while (enumeration.hasMoreElements()) {
                IBuffer buffer = (IBuffer)enumeration.nextElement();
                this.addBuffer(buffer);
            }
            BufferManager.DEFAULT_BUFFER_MANAGER = this;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void addBuffer(IBuffer buffer) {
        if (buffer == null || buffer.getContents() == null) {
            if (buffer != null) {
                this.delayAddBuffer(buffer);
            }
            return;
        }
        super.addBuffer(buffer);
    }

    private void delayAddBuffer(final IBuffer buffer) {
        new Thread(){

            @Override
            public void run() {
                if (buffer.getContents() != null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        Logger.debug(e);
                    }
                    JavaDecompilerBufferManager.this.addBuffer(buffer);
                }
            }
        }.start();
    }

    public void removeBuffer(IBuffer buffer) {
        super.removeBuffer(buffer);
    }

    public IBuffer getBuffer(final IOpenable owner) {
        IClassFile input;
        JavaDecompilerClassFileEditor editor;
        IBuffer buffer = super.getBuffer(owner);
        final IBuffer[] buffers = new IBuffer[]{buffer};
        if (UIUtil.requestFromJavadocHover()) {
            if (buffers[0] == null || buffers[0].getContents() == null) {
                buffers[0] = null;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IClassFile input;
                        JavaDecompilerClassFileEditor editor = UIUtil.getActiveEditor();
                        if (editor != null && editor.getEditorInput() instanceof IClassFileEditorInput && owner.equals(input = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile())) {
                            buffers[0] = editor.getClassBuffer();
                            JavaDecompilerBufferManager.this.addBuffer(buffers[0]);
                        }
                    }
                });
            }
        } else if (UIUtil.requestCreateBuffer() && (editor = UIUtil.getActiveEditor()) != null && editor.getEditorInput() instanceof IClassFileEditorInput && owner.equals(input = ((IClassFileEditorInput)editor.getEditorInput()).getClassFile())) {
            String content = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).get();
            if (buffers[0] != null) {
                if (!content.equals(buffers[0].getContents())) {
                    buffers[0].setContents(content);
                }
            } else {
                ClassFile cf = (ClassFile)input;
                IBuffer classBuffer = BufferManager.createBuffer((IOpenable)cf);
                classBuffer.setContents(content);
                editor.getBufferManager().addBuffer(classBuffer);
                try {
                    ClassFileSourceMap.updateSource(editor.getBufferManager(), cf, content.toCharArray());
                }
                catch (JavaModelException e) {
                    Logger.debug(e);
                }
                buffers[0] = classBuffer;
                this.addBuffer(buffers[0]);
            }
        }
        return buffers[0];
    }
}

