/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.extension;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import org.sf.feeling.decompiler.extension.DecompilerAdapter;
import org.sf.feeling.decompiler.extension.DecompilerAdapterManager;

class ElementAdapterSet
extends TreeSet {
    private static final long serialVersionUID = -3451274084543012212L;
    private static Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof DecompilerAdapter && o2 instanceof DecompilerAdapter) {
                DecompilerAdapter adapter1 = (DecompilerAdapter)o1;
                DecompilerAdapter adapter2 = (DecompilerAdapter)o2;
                if (adapter1.equals(adapter2)) {
                    return 0;
                }
                int value = adapter1.getPriority() - adapter2.getPriority();
                return value == 0 ? 1 : value;
            }
            return 0;
        }
    };
    private List overwriteList;
    private boolean isReset;

    public ElementAdapterSet() {
        super(comparator);
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof DecompilerAdapter) {
            DecompilerAdapter adapter = (DecompilerAdapter)o;
            String[] overwriteIds = adapter.getOverwrite();
            if (overwriteIds != null && overwriteIds.length > 0) {
                if (this.overwriteList == null) {
                    this.overwriteList = new ArrayList();
                }
                int i = 0;
                while (i < overwriteIds.length) {
                    this.overwriteList.add(overwriteIds[i]);
                    ++i;
                }
            }
            return super.add(o);
        }
        return false;
    }

    public void reset() {
        if (!this.isReset && this.overwriteList != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                DecompilerAdapter adapter = (DecompilerAdapter)iterator.next();
                if (!this.overwriteList.contains(adapter.getId())) continue;
                iterator.remove();
                DecompilerAdapterManager.logger.log(Level.FINE, "<" + adapter.getId() + "> is overwritten.");
            }
            this.isReset = true;
        }
    }
}

