/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import org.sf.feeling.decompiler.JavaDecompilerPlugin;
import org.sf.feeling.decompiler.editor.IDecompiler;
import org.sf.feeling.decompiler.editor.IDecompilerDescriptor;
import org.sf.feeling.decompiler.fernflower.FernFlowerDecompiler;
import org.sf.feeling.decompiler.util.UIUtil;

public class ClassUtil {
    public static IDecompiler checkAvailableDecompiler(IDecompiler decompiler, File file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            IDecompiler iDecompiler = ClassUtil.checkAvailableDecompiler(decompiler, fis);
            return iDecompiler;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return decompiler;
    }

    public static IDecompiler checkAvailableDecompiler(IDecompiler decompiler, InputStream is) {
        int classLevel = ClassUtil.getLevel(is);
        boolean debug = ClassUtil.isDebug();
        IDecompiler defaultDecompiler = ClassUtil.getDefaultDecompiler(classLevel, debug);
        if (decompiler.supportLevel(classLevel)) {
            if (debug && !decompiler.supportDebugLevel(classLevel)) {
                String recommendation = "";
                if (JavaDecompilerPlugin.getDefault().isDebug().booleanValue()) {
                    recommendation = String.valueOf(recommendation) + "Disable the 'Align code for debugging' option. ";
                }
                if (UIUtil.isDebugPerspective()) {
                    recommendation = String.valueOf(recommendation) + "Switch to the Java perspective. ";
                }
                if (JavaDecompilerPlugin.getDefault().isDebugMode()) {
                    recommendation = String.valueOf(recommendation) + "Disable the debug Mode. ";
                }
                JavaDecompilerPlugin.logInfo("Could not use " + decompiler.getClass().getSimpleName() + " for decompilation since the debug view is not supported. " + recommendation + "Falling back to " + defaultDecompiler.getClass().getSimpleName() + ".");
                return defaultDecompiler;
            }
        } else {
            JavaDecompilerPlugin.logInfo("Could not use " + decompiler.getClass().getSimpleName() + " for decompilation since the classLevel " + classLevel + " is not supported. " + "Falling back to " + defaultDecompiler.getClass().getSimpleName() + ".");
            return defaultDecompiler;
        }
        return decompiler;
    }

    public static boolean isDebug() {
        return JavaDecompilerPlugin.getDefault().isDebug() != false || UIUtil.isDebugPerspective() || JavaDecompilerPlugin.getDefault().isDebugMode();
    }

    public static boolean greatLevel6(File file) {
        FilterInputStream data = null;
        try {
            data = new DataInputStream(new FileInputStream(file));
            if (-889275714 != ((DataInputStream)data).readInt()) {
                return false;
            }
            ((DataInputStream)data).readUnsignedShort();
            int major = ((DataInputStream)data).readUnsignedShort();
            data.close();
            data = null;
            boolean bl = major >= 51;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static int getLevel(InputStream is) {
        DataInputStream data;
        block3: {
            data = null;
            try {
                data = new DataInputStream(is);
                if (-889275714 == data.readInt()) break block3;
                return -1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        data.readUnsignedShort();
        int major = data.readUnsignedShort();
        return major - 44;
    }

    public static boolean isClassFile(byte[] bytes) {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        DataInputStream data = null;
        try {
            data = new DataInputStream(bis);
            if (-889275714 != data.readInt()) {
                return false;
            }
            data.readUnsignedShort();
            data.readUnsignedShort();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (data != null) {
                try {
                    data.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    public static IDecompiler getDefaultDecompiler(int level, boolean debug) {
        Collection<IDecompilerDescriptor> descriptors = JavaDecompilerPlugin.getDefault().getDecompilerDescriptorMap().values();
        if (descriptors != null) {
            for (IDecompilerDescriptor iDecompilerDescriptor : descriptors) {
                if (!iDecompilerDescriptor.isDefault()) continue;
                IDecompiler decompiler = iDecompilerDescriptor.getDecompiler();
                if (!(debug ? decompiler.supportDebug() && decompiler.supportDebugLevel(level) : decompiler.supportLevel(level))) continue;
                return decompiler;
            }
        }
        return new FernFlowerDecompiler();
    }
}

