/*
 * Decompiled with CFR 0.152.
 */
package org.sf.feeling.decompiler.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.sf.feeling.decompiler.editor.DecompilerSourceMapper;
import org.sf.feeling.decompiler.editor.SourceMapperFactory;
import org.sf.feeling.decompiler.util.ReflectionUtils;
import org.sf.feeling.decompiler.util.SourceMapperUtil;

public class DecompileUtil {
    public static String decompile(IClassFile cf, String type, boolean always, boolean reuseBuf, boolean force) throws CoreException {
        String decompilerType = type;
        String origSrc = cf.getSource();
        if (origSrc == null || always || !reuseBuf || force) {
            DecompilerSourceMapper sourceMapper = SourceMapperFactory.getSourceMapper(decompilerType);
            char[] src = sourceMapper.findSource(cf.getType());
            if (src == null && !"FernFlower".equals(decompilerType)) {
                src = SourceMapperFactory.getSourceMapper("FernFlower").findSource(cf.getType());
            }
            if (src == null) {
                return origSrc;
            }
            return new String(src);
        }
        return origSrc;
    }

    public static String decompiler(FileStoreEditorInput input, String decompilerType) {
        DecompilerSourceMapper sourceMapper = SourceMapperFactory.getSourceMapper(decompilerType);
        File file = new File(input.getURI());
        return sourceMapper.decompile(decompilerType, file);
    }

    public static String getPackageName(String source) {
        Pattern p = Pattern.compile("(?i)package\\s+\\S+");
        Matcher m = p.matcher(source);
        if (m.find()) {
            return m.group().replace("package", "").replace(";", "").trim();
        }
        return null;
    }

    public static String updateBuffer(IClassFile cf, String origSrc) throws JavaModelException {
        DecompileUtil.updateSourceRanges(cf, origSrc);
        return origSrc;
    }

    public static void updateSourceRanges(IClassFile cf, String contents) throws JavaModelException {
        if (cf instanceof ClassFile) {
            ClassFile classFile = (ClassFile)cf;
            Object info = classFile.getElementInfo();
            IBinaryType typeInfo = info instanceof IBinaryType ? (IBinaryType)info : null;
            SourceMapper mapper = classFile.getSourceMapper();
            IType type = (IType)ReflectionUtils.invokeMethod((Object)classFile, "getOuterMostEnclosingType", new Class[0], new Object[0]);
            HashMap sourceRange = (HashMap)ReflectionUtils.getFieldValue(mapper, "sourceRanges");
            sourceRange.remove(type);
            SourceMapperUtil.mapSource(mapper, type, contents.toCharArray(), typeInfo);
        }
    }

    public static String deleteOneEmptyLine(String origSrc) {
        int index = origSrc.indexOf("{");
        if (index == -1) {
            return origSrc;
        }
        String prefix = origSrc.substring(0, index + 1);
        String suffix = origSrc.substring(index + 1);
        ArrayList<String> splits = new ArrayList<String>(Arrays.asList(prefix.split("\n")));
        boolean flag = false;
        int i = 0;
        while (i < splits.size()) {
            String split = (String)splits.get(i);
            if (split.trim().length() == 0) {
                splits.remove(i);
                flag = true;
                break;
            }
            ++i;
        }
        if (flag) {
            StringBuffer buffer = new StringBuffer();
            int i2 = 0;
            while (i2 < splits.size()) {
                String split = (String)splits.get(i2);
                buffer.append(split);
                if (i2 < splits.size() - 1) {
                    buffer.append("\n");
                }
                ++i2;
            }
            buffer.append(suffix);
            return buffer.toString();
        }
        return null;
    }
}

