/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.selenium.ide.format;

import com.kms.katalon.selenium.ide.format.Formatter;
import com.kms.katalon.selenium.ide.model.Command;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class WaitForFormatter
implements Formatter {
    @Override
    public String format(Command command) {
        String formatted = "";
        try {
            formatted = this.checked(command);
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notChecked(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.whether(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notWhether(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.notPresent(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.present(command);
            }
            if (StringUtils.isBlank((CharSequence)formatted)) {
                formatted = this.normal(command);
            }
        }
        catch (Exception exception) {
            formatted = String.format("Method %s is not found", command.getCommand());
        }
        return String.valueOf(formatted) + "\n";
    }

    private String normal(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(waitFor)(.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String suffixMethodName = matcher.group(2);
            String condition = this.conditionWithMatchingOrNotForWaitFor(suffixMethodName, command.getTarget(), command.getValue());
            return this.returnPattern(condition);
        }
        return formatted.toString();
    }

    private String present(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(waitFor)(.*?)(Present)");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolMethod(matcher.group(2), command.getTarget());
            return this.returnPattern(method);
        }
        return formatted.toString();
    }

    private String notPresent(Command command) throws Exception {
        StringBuffer formatted = new StringBuffer();
        Pattern pattern = Pattern.compile("(waitFor)(.*?)(Not)(Present)");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolMethod(matcher.group(2), command.getTarget());
            return this.returnPattern("!" + method);
        }
        return formatted.toString();
    }

    public String checked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(waitFor)(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolCheckedMethod(matcher.group(2), command.getTarget());
            return this.returnPattern(method);
        }
        return "";
    }

    public String whether(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(waitFor)(Whether.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolWhetherMethod(matcher.group(2), command.getTarget(), command.getValue());
            return this.returnPattern(method);
        }
        return "";
    }

    public String notWhether(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(waitForNot)(Whether.*?)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolWhetherMethod(matcher.group(2), command.getTarget(), command.getValue());
            return this.returnPattern("!" + method);
        }
        return "";
    }

    public String notChecked(Command command) throws Exception {
        Pattern pattern = Pattern.compile("(waitForNot)(Checked|Editable|Ordered|Visible|SomethingSelected)$");
        Matcher matcher = pattern.matcher(command.getCommand());
        if (matcher.find()) {
            String method = this.getBoolCheckedMethod(matcher.group(2), command.getTarget());
            return this.returnPattern("!" + method);
        }
        return "";
    }

    private String returnPattern(String condition) {
        return "selenium.waitFor({" + condition + "})";
    }
}

