/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.groovy.reference;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class TestArtifactScriptRefactor {
    private FolderEntity.FolderType parentType;
    private EntityType entityType;
    private String entityId;
    private boolean hasRightBracket;
    private boolean hasRightQuote;
    private boolean hasRightDoubleQuote;
    private boolean isFolder;

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote) {
        this(parentType, null, entityId, hasRightBracket, hasRightQuote, hasRightDoubleQuote, false);
    }

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this(parentType, null, entityId, hasRightBracket, hasRightQuote, hasRightDoubleQuote, isFolder);
    }

    public TestArtifactScriptRefactor(FolderEntity.FolderType parentType, EntityType entityType, String entityId, boolean hasRightBracket, boolean hasRightQuote, boolean hasRightDoubleQuote, boolean isFolder) {
        this.parentType = parentType;
        this.entityType = entityType;
        this.entityId = entityId;
        this.hasRightBracket = hasRightBracket;
        this.hasRightQuote = hasRightQuote;
        this.hasRightDoubleQuote = hasRightDoubleQuote;
        this.isFolder = isFolder;
    }

    public FolderEntity.FolderType getParentType() {
        return this.parentType;
    }

    public String getEntityId() {
        return this.entityId;
    }

    private String getReferencePrefixByEntityType() {
        if (this.entityType == null) {
            return "";
        }
        switch (this.entityType) {
            case WEBELEMENT: {
                return "findTestObject";
            }
            case WINDOWSELEMENT: {
                return "findWindowsObject";
            }
        }
        return "";
    }

    private String getReferencePrefix() {
        String prefix = this.getReferencePrefixByEntityType();
        if (!prefix.isEmpty()) {
            return prefix;
        }
        switch (this.parentType) {
            case DATAFILE: {
                return "findTestData";
            }
            case TESTCASE: {
                return "findTestCase";
            }
            case WEBELEMENT: {
                return "findTestObject";
            }
            case CHECKPOINT: {
                return "findCheckpoint";
            }
        }
        return "";
    }

    private String getRelativeId(String s) {
        int firstSeparatorIdx = s.indexOf("/");
        if (firstSeparatorIdx < 0) {
            return s;
        }
        return s.substring(firstSeparatorIdx + 1, s.length());
    }

    private String buildParentheses(String s) {
        return "(" + s + (this.hasRightBracket ? ")" : "");
    }

    private String buildQuote(String s) {
        return "'" + s + (this.hasRightQuote ? "'" : "");
    }

    private String buildDoubleQuotes(String s) {
        return "\"" + s + (this.hasRightDoubleQuote ? "\"" : "");
    }

    public List<String> getReferenceStrings() {
        ArrayList<String> referenceString = new ArrayList<String>();
        referenceString.add(this.getQuotedReferencesRelativeId());
        referenceString.add(this.getQuotedReferencesEntityId());
        referenceString.add(this.getDoubleQuotedReferenceStringsRelativeId());
        referenceString.add(this.getDoubleQuotedReferenceStringsEntityId());
        return referenceString;
    }

    private String getQuotedReferencesRelativeId() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return String.valueOf(prefix) + this.buildParentheses(this.buildQuote(relativeId));
    }

    private String getQuotedReferencesEntityId() {
        String prefix = this.getReferencePrefix();
        return String.valueOf(prefix) + this.buildParentheses(this.buildQuote(this.entityId));
    }

    private String getDoubleQuotedReferenceStringsRelativeId() {
        String prefix = this.getReferencePrefix();
        String relativeId = this.getRelativeId(this.entityId);
        return String.valueOf(prefix) + this.buildParentheses(this.buildDoubleQuotes(relativeId));
    }

    private String getDoubleQuotedReferenceStringsEntityId() {
        String prefix = this.getReferencePrefix();
        return String.valueOf(prefix) + this.buildParentheses(this.buildDoubleQuotes(this.entityId));
    }

    public void replace(String newEntityId, IFile scriptFile, String referencePrefix) throws IOException, CoreException {
        String scriptContent = this.getScriptContent(scriptFile);
        String newRelativeId = this.getRelativeId(newEntityId);
        boolean updated = false;
        String newQuotedScriptRelativeId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildQuote(newRelativeId));
        String newQuotedScriptEntityId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildQuote(newEntityId));
        String oldQuotedScriptRelativeId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildQuote(this.getRelativeId(this.entityId)));
        String oldQuotedScriptEntityId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildQuote(this.entityId));
        if (scriptContent.contains(oldQuotedScriptRelativeId)) {
            scriptContent = scriptContent.replace(oldQuotedScriptRelativeId, newQuotedScriptRelativeId);
            updated = true;
        }
        if (scriptContent.contains(oldQuotedScriptEntityId)) {
            scriptContent = scriptContent.replace(oldQuotedScriptEntityId, newQuotedScriptEntityId);
            updated = true;
        }
        String newDoubleQuotedScriptRelativeId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildDoubleQuotes(newRelativeId));
        String newDoubleQuotedScriptEntityId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildDoubleQuotes(newEntityId));
        String oldDoubleQuotedScriptRelativeId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildDoubleQuotes(this.getRelativeId(this.entityId)));
        String oldDoubleQuotedScriptEntityId = String.valueOf(referencePrefix) + this.buildParentheses(this.buildDoubleQuotes(this.entityId));
        if (scriptContent.contains(oldDoubleQuotedScriptRelativeId)) {
            scriptContent = scriptContent.replace(oldDoubleQuotedScriptRelativeId, newDoubleQuotedScriptRelativeId);
            updated = true;
        }
        if (scriptContent.contains(oldDoubleQuotedScriptEntityId)) {
            scriptContent = scriptContent.replace(oldDoubleQuotedScriptEntityId, newDoubleQuotedScriptEntityId);
            updated = true;
        }
        if (!updated) {
            return;
        }
        Throwable throwable = null;
        Object var16_17 = null;
        try (InputStream is = IOUtils.toInputStream((String)scriptContent, (String)"UTF-8");){
            scriptFile.setContents(is, true, true, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getScriptContent(IFile scriptFile) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream scriptFileStreamContent = scriptFile.getContents();){
            return IOUtils.toString((InputStream)scriptFileStreamContent, (String)"UTF-8");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public boolean hasReferenceInScript(IFile scriptFile) throws IOException, CoreException {
        String scriptContent = this.getScriptContent(scriptFile);
        for (String potentialRef : this.getReferenceStrings()) {
            if (!scriptContent.contains(potentialRef)) continue;
            return true;
        }
        return false;
    }

    public List<IFile> findReferrers(List<IFile> files) throws IOException, CoreException {
        ArrayList<IFile> referrers = new ArrayList<IFile>();
        for (IFile scriptFile : files) {
            if (!this.hasReferenceInScript(scriptFile)) continue;
            referrers.add(scriptFile);
        }
        return referrers;
    }

    public List<IFile> findReferrersInScriptsAndVariables(ProjectEntity projectEntity) throws IOException, CoreException {
        ArrayList<IFile> files = new ArrayList<IFile>();
        files.addAll(GroovyUtil.getAllScriptFiles(projectEntity));
        files.addAll(GroovyUtil.getAllGlobalVariableFiles(projectEntity));
        files.addAll(GroovyUtil.getAllTestCaseFiles(projectEntity));
        return this.findReferrers(files);
    }

    public List<IFile> findReferrersInTestCaseScripts(ProjectEntity projectEntity) throws IOException, CoreException {
        return this.findReferrers(GroovyUtil.getAllTestCaseScripts(projectEntity));
    }

    public void updateReferenceForProject(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferenceForTestCaseFolder(newScript, projectEntity);
        this.updateReferenceForTestListeners(newScript, projectEntity);
        switch (this.parentType) {
            case TESTCASE: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case WEBELEMENT: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case DATAFILE: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
            case CHECKPOINT: {
                this.updateReferenceForTestSuitesFolder(newScript, projectEntity);
                this.updateReferenceForCustomKeywords(newScript, projectEntity);
                this.updateReferenceForStepDefinitions(newScript, projectEntity);
                break;
            }
        }
    }

    private void updateReferenceForTestListeners(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllTestListenerScripts(projectEntity));
    }

    public void updateReferenceForTestCaseFolder(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllTestCaseScripts(projectEntity));
    }

    public void updateReferenceForCustomKeywords(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllCustomKeywordsScripts(projectEntity));
    }

    private void updateReferenceForTestSuitesFolder(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllTestSuiteScripts(projectEntity));
    }

    private void updateReferenceForStepDefinitions(String newScript, ProjectEntity projectEntity) throws IOException, CoreException {
        this.updateReferences(newScript, GroovyUtil.getAllStepDefinitionScripts(projectEntity));
    }

    public void updateReferences(String newScript, List<IFile> files) throws IOException, CoreException {
        for (IFile scriptFile : files) {
            if (this.isFolder && this.parentType == FolderEntity.FolderType.WEBELEMENT) {
                this.replace(newScript, scriptFile, "findTestObject");
                this.replace(newScript, scriptFile, "findWindowsObject");
                continue;
            }
            this.replace(newScript, scriptFile, this.getReferencePrefix());
        }
    }

    public void removeReferences(List<IFile> files) throws IOException, CoreException {
        this.updateReferences(GlobalStringConstants.NULL, files);
    }

    public static TestArtifactScriptRefactor createForTestDataEntity(String testDataId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.DATAFILE, testDataId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestCaseEntity(String testCaseId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.TESTCASE, testCaseId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForTestObjectEntity(String testObjectId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.WEBELEMENT, EntityType.WEBELEMENT, testObjectId, false, true, true, false);
    }

    public static TestArtifactScriptRefactor createForWindowsObjectEntity(String testObjectId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.WEBELEMENT, EntityType.WINDOWSELEMENT, testObjectId, false, true, true, false);
    }

    public static TestArtifactScriptRefactor createForCheckpointEntity(String checkpointId) {
        return new TestArtifactScriptRefactor(FolderEntity.FolderType.CHECKPOINT, checkpointId, true, true, true);
    }

    public static TestArtifactScriptRefactor createForFolderEntity(FolderEntity folder) {
        return new TestArtifactScriptRefactor(folder.getFolderType(), String.valueOf(folder.getIdForDisplay()) + "/", false, false, false, true);
    }

    public static enum EntityType {
        DATAFILE,
        TESTCASE,
        CHECKPOINT,
        WEBELEMENT,
        WINDOWSELEMENT;

    }
}

