/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.preferences.internal;

import com.kms.katalon.preferences.PreferenceNodeDescription;
import com.kms.katalon.preferences.internal.IPreferenceStoreProvider;
import com.kms.katalon.preferences.internal.PreferenceNodeDescriptionImpl;
import com.kms.katalon.preferences.internal.PreferenceStoreManager;
import com.kms.katalon.preferences.internal.ScopedPreferenceStore;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

@Creatable
public class PreferencesRegistry {
    public static final String PREFS_PAGE_XP = "com.kms.katalon.preferences.PreferencePages";
    public static final String PREFS_PROJECT_XP = "com.kms.katalon.preferences.ProjectSettingPages";
    public static final String PREF_STORE_PROVIDER = "com.kms.katalon.preferences.PreferenceStoreProvider";
    protected static final String ELMT_PAGE = "page";
    protected static final String ATTR_ID = "id";
    protected static final String ATTR_CATEGORY = "category";
    protected static final String ATTR_CLASS = "class";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_PLUGIN_ID = "pluginId";
    protected static final String ATTR_ID_IN_WBCONTEXT = "idInWorkbenchContext";
    @Inject
    protected Logger logger;
    @Inject
    protected IEclipseContext context;
    @Inject
    protected IExtensionRegistry registry;
    private PreferenceManager pm = null;
    private Map<String, Object> psProviders;

    public PreferenceManager getPreferenceManager(String perferencePage, boolean isPlatformStudio) {
        return this.getPreferenceManager(perferencePage, Collections.emptyMap(), isPlatformStudio);
    }

    public PreferenceManager getPreferenceManager(String perferencePage, Map<String, List<PreferenceNodeDescription>> additional, boolean isPlatformStudio) {
        if (this.pm != null) {
            return this.pm;
        }
        HashMap<String, List<PreferenceNodeDescription>> nodeDescriptionLookup = new HashMap<String, List<PreferenceNodeDescription>>();
        nodeDescriptionLookup.putAll(additional);
        this.pm = new PreferenceManager();
        IContributionFactory factory = (IContributionFactory)this.context.get(IContributionFactory.class);
        IConfigurationElement[] iConfigurationElementArray = this.registry.getConfigurationElementsFor(perferencePage);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement elmt = iConfigurationElementArray[n2];
            String bundleId = elmt.getNamespaceIdentifier();
            String prefPageClassname = elmt.getAttribute(ATTR_CLASS);
            String category = elmt.getAttribute(ATTR_CATEGORY) != null ? elmt.getAttribute(ATTR_CATEGORY) : "";
            String nodeId = elmt.getAttribute(ATTR_ID);
            String nodeName = elmt.getAttribute(ATTR_NAME);
            if (!elmt.getName().equals(ELMT_PAGE)) {
                this.logger.warn("unexpected element: {0}", (Object)elmt.getName());
            } else if (this.isEmpty(nodeId) || this.isEmpty(nodeName)) {
                this.logger.warn("missing id and/or name: {}", (Object)bundleId);
            } else {
                PreferenceNodeDescriptionImpl nodeDesc = new PreferenceNodeDescriptionImpl(bundleId, nodeId, nodeName, category, prefPageClassname, isPlatformStudio);
                if (nodeDescriptionLookup.containsKey(category)) {
                    ArrayList<PreferenceNodeDescriptionImpl> children = new ArrayList<PreferenceNodeDescriptionImpl>((Collection)nodeDescriptionLookup.get(category));
                    children.add(nodeDesc);
                    nodeDescriptionLookup.put(category, children);
                } else {
                    nodeDescriptionLookup.put(category, Arrays.asList(nodeDesc));
                }
            }
            ++n2;
        }
        ArrayList<String> categoriesDone = new ArrayList<String>();
        while (!nodeDescriptionLookup.isEmpty()) {
            for (String cat : Collections.unmodifiableSet(nodeDescriptionLookup.keySet())) {
                IPreferenceNode parent = this.findNode(this.pm, cat);
                if (parent == null && !cat.isEmpty()) continue;
                for (PreferenceNodeDescription pnDesc : (List)nodeDescriptionLookup.get(cat)) {
                    PreferenceNode pn = null;
                    if (!pnDesc.hasPage()) {
                        pn = new PreferenceNode(pnDesc.getNodeId(), (IPreferencePage)new EmptyPreferencePage(pnDesc.getNodeName()));
                    } else {
                        PreferencePage page = pnDesc.getBuilder().build(factory, this.context);
                        if (page == null) continue;
                        if (page.getPreferenceStore() == null) {
                            this.setPreferenceStore(pnDesc.getBundleId(), page);
                        }
                        ContextInjectionFactory.inject((Object)page, (IEclipseContext)this.context);
                        if ((page.getTitle() == null || page.getTitle().isEmpty()) && pnDesc.getNodeName() != null) {
                            page.setTitle(pnDesc.getNodeName());
                        }
                        pn = new PreferenceNode(pnDesc.getNodeId(), (IPreferencePage)page);
                    }
                    if (parent != null) {
                        parent.add((IPreferenceNode)pn);
                        continue;
                    }
                    this.pm.addToRoot((IPreferenceNode)pn);
                }
                categoriesDone.add(cat);
            }
            for (String keyToRemove : categoriesDone) {
                nodeDescriptionLookup.remove(keyToRemove);
            }
            categoriesDone.clear();
        }
        return this.pm;
    }

    private void setPreferenceStore(String bundleId, PreferencePage page) {
        this.initialisePreferenceStoreProviders();
        ScopedPreferenceStore store = null;
        Object data = this.psProviders.get(bundleId);
        if (data != null) {
            if (data instanceof IPreferenceStore) {
                store = (IPreferenceStore)data;
            } else if (data instanceof IPreferenceStoreProvider) {
                store = ((IPreferenceStoreProvider)data).getPreferenceStore();
            } else if (data instanceof String) {
                store = (IPreferenceStore)this.context.get((String)data);
            }
        } else {
            store = PreferenceStoreManager.getPreferenceStore(bundleId);
            this.psProviders.put(bundleId, (Object)store);
        }
        if (store != null) {
            page.setPreferenceStore((IPreferenceStore)store);
        } else {
            this.logger.warn(MessageFormat.format("Unable to set the preferenceStore for page {0} defined in bundle {1}", page.getTitle(), bundleId));
        }
    }

    /*
     * Unable to fully structure code
     */
    private void initialisePreferenceStoreProviders() {
        if (this.psProviders == null) {
            factory = (IContributionFactory)this.context.get(IContributionFactory.class);
            this.psProviders = new HashMap<String, Object>();
            var5_2 = this.registry.getConfigurationElementsFor("com.kms.katalon.preferences.PreferenceStoreProvider");
            var4_3 = var5_2.length;
            var3_4 = 0;
            while (var3_4 < var4_3) {
                elmt = var5_2[var3_4];
                declaringBundle = elmt.getNamespaceIdentifier();
                pluginId = elmt.getAttribute("pluginId");
                if (this.isEmpty(pluginId)) {
                    this.logger.warn(MessageFormat.format("missing plugin Id in extension {0} check the plugin {1}", new Object[]{"com.kms.katalon.preferences.PreferenceStoreProvider", declaringBundle}));
                } else {
                    classname = elmt.getAttribute("class");
                    objectId = elmt.getAttribute("idInWorkbenchContext");
                    if (this.isEmpty(classname) && this.isEmpty(objectId) || classname != null && classname.length() > 0 && objectId != null && objectId.length() > 0) {
                        this.logger.warn(MessageFormat.format("In extension {0} only one of the two attributes (pluginId or idInWorkbenchContext) must be set. Check the plugin {1}", new Object[]{"com.kms.katalon.preferences.PreferenceStoreProvider", declaringBundle}));
                    } else {
                        data = objectId;
                        if (classname != null) {
                            try {
                                prefStoreProviderURI = this.getClassURI(pluginId, elmt.getAttribute("class"));
                                data = factory.create(prefStoreProviderURI, this.context);
                                if (!(data instanceof IPreferenceStoreProvider)) {
                                    this.logger.warn(MessageFormat.format("In extension {0} the class must implements IPreferenceStoreProvider. Check the plugin {1}", new Object[]{"com.kms.katalon.preferences.PreferenceStoreProvider", declaringBundle}));
                                }
                                ** break block12
                            }
                            catch (ClassNotFoundException e) {
                                this.logger.warn(e.getMessage());
                            }
                            catch (InvalidRegistryObjectException e) {
                                this.logger.warn(e.getMessage());
                            }
                        } else lbl-1000:
                        // 2 sources

                        {
                            this.psProviders.put(pluginId, data);
                        }
                    }
                }
                ++var3_4;
            }
        }
    }

    private IPreferenceNode findNode(PreferenceManager pm, String categoryId) {
        for (Object o : pm.getElements(1)) {
            if (!(o instanceof IPreferenceNode) || !((IPreferenceNode)o).getId().equals(categoryId)) continue;
            return (IPreferenceNode)o;
        }
        return null;
    }

    private String getClassURI(String definingBundleId, String spec) throws ClassNotFoundException {
        if (spec.startsWith("platform:")) {
            return spec;
        }
        return "bundleclass://" + definingBundleId + '/' + spec;
    }

    private boolean isEmpty(String value) {
        return value == null || value.trim().isEmpty();
    }

    static class EmptyPreferencePage
    extends PreferencePage {
        public EmptyPreferencePage(String title) {
            this.setTitle(title);
            this.noDefaultAndApplyButton();
        }

        protected Control createContents(Composite parent) {
            return new Label(parent, 0);
        }
    }
}

