/*
 * Decompiled with CFR 0.152.
 */
package v2.io.swagger.parser.processors;

import java.util.List;
import java.util.Map;
import v2.io.swagger.models.Operation;
import v2.io.swagger.models.RefResponse;
import v2.io.swagger.models.Response;
import v2.io.swagger.models.Swagger;
import v2.io.swagger.models.parameters.Parameter;
import v2.io.swagger.parser.ResolverCache;
import v2.io.swagger.parser.processors.ParameterProcessor;
import v2.io.swagger.parser.processors.ResponseProcessor;

public class OperationProcessor {
    private final ParameterProcessor parameterProcessor;
    private final ResponseProcessor responseProcessor;
    private final ResolverCache cache;

    public OperationProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.parameterProcessor = new ParameterProcessor(cache, swagger);
        this.responseProcessor = new ResponseProcessor(cache, swagger);
    }

    public void processOperation(Operation operation) {
        List<Parameter> processedOperationParameters = this.parameterProcessor.processParameters(operation.getParameters());
        operation.setParameters(processedOperationParameters);
        Map<String, Response> responses = operation.getResponses();
        if (responses != null) {
            for (String responseCode : responses.keySet()) {
                RefResponse refResponse;
                Response resolvedResponse;
                Response response = responses.get(responseCode);
                if (response == null) continue;
                if (response instanceof RefResponse && (resolvedResponse = this.cache.loadRef((refResponse = (RefResponse)response).get$ref(), refResponse.getRefFormat(), Response.class)) != null) {
                    response = resolvedResponse;
                    responses.put(responseCode, resolvedResponse);
                }
                this.responseProcessor.processResponse(response);
            }
        }
    }
}

