/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.component;

import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationRef;
import com.kms.katalon.integration.azure.model.AzureTestConfigurationsRef;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;

public class AzureTestConfigurationEditingSupport
extends EditingSupport {
    private TableViewer viewer;
    private AzureTestConfigurationsRef suggestions = null;

    public AzureTestConfigurationEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        String[] items = this.getSuggestions();
        if (items == null) {
            items = new String[]{};
        }
        AzureTestConfigurationCellEditor editor = new AzureTestConfigurationCellEditor(element, items);
        return editor;
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (this.isSuggestionsPresent()) {
            return "";
        }
        if (element instanceof TestConfigurationMapping) {
            int testConfigId = ((TestConfigurationMapping)element).getAzureTestConfigurationId();
            AzureTestConfigurationRef testConfig = this.suggestions.findById(testConfigId);
            return testConfig != null ? testConfig.getName() : this.suggestions.getValue()[0].getName();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        if (element == null || value == null || this.isSuggestionsPresent()) {
            return;
        }
        AzureTestConfigurationRef[] suggestionList = this.suggestions.getValue();
        if (element instanceof TestConfigurationMapping && value instanceof Integer) {
            TestConfigurationMapping testConfigurationMapping = (TestConfigurationMapping)element;
            int azureTestConfigurationId = testConfigurationMapping.getAzureTestConfigurationId();
            int selectedIndex = (Integer)value;
            int selectedTestConfigurationId = suggestionList[selectedIndex].getId();
            if (selectedTestConfigurationId != azureTestConfigurationId) {
                testConfigurationMapping.setAzureTestConfigurationId(selectedTestConfigurationId);
                this.viewer.update((Object)testConfigurationMapping, null);
            }
        }
    }

    private String[] getSuggestions() {
        if (this.suggestions == null || this.suggestions.getCount() <= 0) {
            return null;
        }
        AzureTestConfigurationRef[] testConfigList = this.suggestions.getValue();
        return Arrays.asList(testConfigList).stream().map(testConfig -> testConfig.getName()).collect(Collectors.toList()).toArray(new String[this.suggestions.getCount()]);
    }

    private boolean isSuggestionsPresent() {
        return this.suggestions == null || this.suggestions.getCount() <= 0;
    }

    public void updateSuggestions(AzureTestConfigurationsRef testConfigurations) {
        this.suggestions = testConfigurations;
    }

    private class AzureTestConfigurationCellEditor
    extends StringComboBoxCellEditor {
        public AzureTestConfigurationCellEditor(final Object element, String[] items) {
            super((Composite)AzureTestConfigurationEditingSupport.this.viewer.getTable(), items, 8);
            final CCombo combo = (CCombo)this.getControl();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int selectedIndex = combo.getSelectionIndex();
                    AzureTestConfigurationEditingSupport.this.setValue(element, selectedIndex);
                }
            });
        }
    }
}

