/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.component;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.integration.azure.component.AzureProgressDialog;
import com.kms.katalon.composer.integration.azure.component.AzureVerifyTestCasesResult;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.entity.util.EntityTagUtil;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureTestSuiteRef;
import com.kms.katalon.integration.azure.model.AzureTestSuitesRef;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;

public class AzureVerifyTestCasesJob
extends AzureProgressDialog {
    private AzureCredential credential;
    private AzureProjectRef project;
    Set<String> testCaseIds;

    public AzureVerifyTestCasesJob(Shell parent, AzureCredential credential, AzureProjectRef project, String rawTestCaseIds) {
        super(parent);
        this.credential = credential;
        this.project = project;
        this.testCaseIds = EntityTagUtil.parse((String)rawTestCaseIds);
    }

    @Override
    public AzureVerifyTestCasesResult run() {
        final AzureVerifyTestCasesResult result = new AzureVerifyTestCasesResult();
        try {
            this.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(StringConstants.MSG_VERIFYING_TEST_CASES, AzureVerifyTestCasesJob.this.testCaseIds.size());
                    for (String id : AzureVerifyTestCasesJob.this.testCaseIds) {
                        monitor.subTask(MessageFormat.format(StringConstants.MSG_VERIFYING_TEST_CASE, id));
                        if (!AzureVerifyTestCasesJob.this.isPositiveInteger(id)) {
                            result.addErrorFormatTestCaseId(id);
                        } else {
                            int testCaseId = Integer.parseInt(id);
                            try {
                                if (!AzureVerifyTestCasesJob.this.isTestCaseInIntegratedProject(testCaseId)) {
                                    result.addUnrealTestCaseId(id);
                                }
                            }
                            catch (AzureApiException exception) {
                                LoggerSingleton.logError((Throwable)exception, (String)MessageFormat.format(StringConstants.MSG_ERROR_FETCHING_TEST_CASE, id));
                                result.addUnrealTestCaseId(id);
                                result.setError((Exception)((Object)exception));
                            }
                        }
                        monitor.worked(1);
                    }
                    monitor.done();
                }
            });
        }
        catch (InterruptedException | InvocationTargetException exception) {}
        return result;
    }

    private boolean isPositiveInteger(String number) {
        if (number == null) {
            return false;
        }
        try {
            int parsedNumber = Integer.parseInt(number);
            return parsedNumber >= 0;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private boolean isTestCaseInIntegratedProject(int testCaseId) throws AzureApiException {
        AzureTestSuitesRef testSuites = AzureIntegrationRequest.getTestSuitesByTestCaseId((AzureCredential)this.credential, (int)testCaseId);
        AzureTestSuiteRef[] azureTestSuiteRefArray = testSuites.getValue();
        int n = azureTestSuiteRefArray.length;
        int n2 = 0;
        while (n2 < n) {
            AzureTestSuiteRef testSuite = azureTestSuiteRefArray[n2];
            if (testSuite.getProject().getId().equals(this.project.getId())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

