/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.component;

import com.kms.katalon.composer.components.adapter.CComboContentAdapter;
import com.kms.katalon.composer.components.impl.editors.StringComboBoxCellEditor;
import com.kms.katalon.integration.azure.setting.ExecutionMappingUtil;
import com.kms.katalon.integration.azure.setting.TestConfigurationMapping;
import org.eclipse.jface.fieldassist.AutoCompleteField;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ExecutionPlatformEditingSupport
extends EditingSupport {
    private TableViewer viewer;

    public ExecutionPlatformEditingSupport(TableViewer viewer) {
        super((ColumnViewer)viewer);
        this.viewer = viewer;
    }

    protected CellEditor getCellEditor(Object element) {
        return new ExecutionPlatformCellEditor(element, ExecutionMappingUtil.EXECUTION_PLATFORMS);
    }

    protected boolean canEdit(Object element) {
        return true;
    }

    protected Object getValue(Object element) {
        if (element instanceof TestConfigurationMapping) {
            return ((TestConfigurationMapping)element).getPlatform();
        }
        return "";
    }

    protected void setValue(Object element, Object value) {
        TestConfigurationMapping testConfigurationMapping;
        String platform;
        if (element == null || value == null) {
            return;
        }
        if (element instanceof TestConfigurationMapping && value instanceof String && !value.equals(platform = (testConfigurationMapping = (TestConfigurationMapping)element).getPlatform())) {
            testConfigurationMapping.setPlatform((String)value);
            this.viewer.update((Object)testConfigurationMapping, null);
        }
    }

    private class ExecutionPlatformCellEditor
    extends StringComboBoxCellEditor {
        private Object element;

        public ExecutionPlatformCellEditor(final Object element, String[] items) {
            super((Composite)ExecutionPlatformEditingSupport.this.viewer.getTable(), items);
            this.element = element;
            final CCombo combo = (CCombo)this.getControl();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    String text = combo.getText();
                    ExecutionPlatformEditingSupport.this.setValue(element, text);
                }
            });
            combo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = combo.getText();
                    ExecutionPlatformEditingSupport.this.setValue(element, text);
                }
            });
        }

        public AutoCompleteField getAutoCompleteField(String[] newItems) {
            return new AutoCompleteField(this.getControl(), (IControlContentAdapter)new ExecutionPlatformComboContentAdapter(), newItems);
        }

        private class ExecutionPlatformComboContentAdapter
        extends CComboContentAdapter {
            private ExecutionPlatformComboContentAdapter() {
            }

            public void setControlContents(Control control, String text, int cursorPosition) {
                super.setControlContents(control, text, cursorPosition);
                ExecutionPlatformEditingSupport.this.setValue(ExecutionPlatformCellEditor.this.element, text);
            }
        }
    }
}

