/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AzureAuthenticationComposite
extends Group {
    private Text txtServerUrl;
    private Text txtToken;
    private Button chckEncrypt;
    private Button btnConnect;
    private Label lblConnectionStatus;
    private AzureSettingStore settingStore;
    private FocusListener clearMessageListener = new FocusListener(){

        public void focusGained(FocusEvent e) {
        }

        public void focusLost(FocusEvent e) {
            AzureAuthenticationComposite.this.clearMessage();
        }
    };

    public AzureAuthenticationComposite(Composite parent, AzureSettingStore settingStore) {
        super(parent, 0);
        this.settingStore = settingStore;
        ComponentBuilder.fromGrid((Composite)this).text(StringConstants.GRP_AUTHENTICATION).fillHorizontal().numCols(2).build();
        this.createContents((Composite)this);
        this.initializeData();
    }

    protected void checkSubclass() {
    }

    private Control createContents(Composite parent) {
        ComponentBuilder.label((Composite)parent, (int)0).text(StringConstants.LBL_SERVER_URL).build();
        this.txtServerUrl = (Text)ComponentBuilder.text((Composite)parent, (int)2048).placeholder(StringConstants.MSG_SERVER_URL_EXAMPLE).fillHorizontal().build();
        Composite tokenComposite = (Composite)ComponentBuilder.gridContainer((Composite)parent, (int)2, (int)0).margin(0).build();
        ComponentBuilder.label((Composite)tokenComposite, (int)0).text(StringConstants.LBL_TOKEN).build();
        ComponentBuilder.helpButton((Composite)tokenComposite, (String)StringConstants.DOCS_PERSONAL_ACCESS_TOKEN).build();
        this.txtToken = (Text)ComponentBuilder.text((Composite)parent, (int)0x400800).fillHorizontal().build();
        this.chckEncrypt = (Button)ComponentBuilder.button((Composite)parent, (int)32).fillHorizontal().text(StringConstants.CHCK_ENCRYPT_PASSWORD).colSpan(2).build();
        this.btnConnect = (Button)ComponentBuilder.button((Composite)parent, (int)0).text(StringConstants.BTN_CONNECT).width(150).build();
        this.lblConnectionStatus = (Label)ComponentBuilder.label((Composite)parent, (int)64).fillHorizontal().text("").build();
        this.registerControlModifyListeners();
        return this;
    }

    private void registerControlModifyListeners() {
        ModifyListener textModifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AzureAuthenticationComposite.this.btnConnect.setEnabled(AzureAuthenticationComposite.this.canConnect());
            }
        };
        this.txtServerUrl.addModifyListener(textModifyListener);
        this.txtToken.addModifyListener(textModifyListener);
    }

    public void addConnectionListener(SelectionAdapter listener) {
        this.btnConnect.addSelectionListener((SelectionListener)listener);
    }

    private String getTrimmedValue(Text text) {
        return StringUtils.defaultString((String)text.getText()).trim();
    }

    public AzureCredential getEddingCredential() {
        AzureCredential credential = new AzureCredential();
        credential.setServerUrl(this.getTrimmedValue(this.txtServerUrl));
        credential.setToken(this.txtToken.getText());
        return credential;
    }

    public void initializeData() {
        boolean isEncyptionEnabled = this.settingStore.isEncryptionEnabled();
        this.txtServerUrl.setText(this.settingStore.getServerUrl());
        this.txtToken.setText(this.settingStore.getToken(isEncyptionEnabled));
        this.chckEncrypt.setSelection(isEncyptionEnabled);
    }

    public boolean checkValidationBeforeSaving() {
        try {
            AzureIntegrationRequest.getProjects((AzureCredential)this.getEddingCredential());
        }
        catch (AzureApiException exception) {
            MessageDialog.openError((Shell)this.getShell(), (String)StringConstants.AZURE_DEVOPS_NAME, (String)(String.valueOf(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS) + " " + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_AUTHENTICATION));
            LoggerSingleton.logError((Throwable)exception.fillInStackTrace());
            return false;
        }
        return true;
    }

    public void saveToSettingStore() throws IOException, GeneralSecurityException {
        boolean isEncrypted = this.chckEncrypt.getSelection();
        this.settingStore.setServerUrl(this.getTrimmedValue(this.txtServerUrl), isEncrypted);
        this.settingStore.setToken(this.txtToken.getText(), isEncrypted);
        this.settingStore.setEncryption(isEncrypted);
    }

    public void enableButtonConnect(boolean isEnabled) {
        if (!this.canConnect()) {
            this.btnConnect.setEnabled(false);
        }
        this.btnConnect.setEnabled(isEnabled);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.txtServerUrl.getText()) && StringUtils.isEmpty((CharSequence)this.txtToken.getText());
    }

    public void clearMessage() {
        this.lblConnectionStatus.setText("");
        this.lblConnectionStatus.requestLayout();
    }

    public void showConnectingMessage() {
        this.lblConnectionStatus.setForeground(this.lblConnectionStatus.getDisplay().getSystemColor(8));
        this.lblConnectionStatus.setText(StringConstants.MSG_DLG_PRG_CONNECTING_AZURE);
        this.lblConnectionStatus.requestLayout();
        this.btnConnect.removeFocusListener(this.clearMessageListener);
    }

    public void showSuccessMessage() {
        this.enableButtonConnect(true);
        this.btnConnect.setFocus();
        this.lblConnectionStatus.setForeground(this.lblConnectionStatus.getDisplay().getSystemColor(6));
        this.lblConnectionStatus.setText(StringConstants.MSG_SUCCESS_CONNECTION);
        this.lblConnectionStatus.requestLayout();
        this.btnConnect.addFocusListener(this.clearMessageListener);
    }

    public void showErrorMessage(String message) {
        this.enableButtonConnect(true);
        this.btnConnect.setFocus();
        this.lblConnectionStatus.setForeground(this.lblConnectionStatus.getDisplay().getSystemColor(4));
        this.lblConnectionStatus.setText(message);
        this.lblConnectionStatus.requestLayout();
        this.btnConnect.addFocusListener(this.clearMessageListener);
    }

    public void showErrorMessage(Exception exception) {
        this.enableButtonConnect(true);
        this.btnConnect.setFocus();
        this.lblConnectionStatus.setForeground(this.lblConnectionStatus.getDisplay().getSystemColor(4));
        this.lblConnectionStatus.setText("Failed: " + exception.getMessage().split("\n")[0]);
        this.lblConnectionStatus.requestLayout();
        this.btnConnect.addFocusListener(this.clearMessageListener);
    }

    private boolean canConnect() {
        return StringUtils.isNotBlank((CharSequence)this.txtServerUrl.getText()) && StringUtils.isNotEmpty((CharSequence)this.txtToken.getText());
    }

    public void setEnabled(boolean isEnabled) {
        ControlUtils.recursiveSetEnabled((Control)this, (boolean)isEnabled);
        if (isEnabled && !this.canConnect()) {
            this.btnConnect.setEnabled(false);
        }
    }

    public void restoreToDefault() {
        this.initializeData();
    }
}

