/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.integration.azure.preference.composite;

import com.kms.katalon.composer.components.impl.control.ExpandableComposite;
import com.kms.katalon.composer.components.util.ComponentBuilder;
import com.kms.katalon.composer.components.util.FontUtil;
import com.kms.katalon.composer.integration.azure.constant.StringConstants;
import com.kms.katalon.core.setting.ReportFormatType;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.integration.azure.exception.AzureApiException;
import com.kms.katalon.integration.azure.model.AzureCredential;
import com.kms.katalon.integration.azure.model.AzureProjectRef;
import com.kms.katalon.integration.azure.model.AzureReleaseDefinitionRef;
import com.kms.katalon.integration.azure.model.AzureTestPlanRef;
import com.kms.katalon.integration.azure.model.AzureTestPlansRef;
import com.kms.katalon.integration.azure.model.ShallowReference;
import com.kms.katalon.integration.azure.provider.AzureIntegrationRequest;
import com.kms.katalon.integration.azure.setting.AzureAttachmentSendingType;
import com.kms.katalon.integration.azure.setting.AzureSettingStore;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubmissionOptionsComposite
extends ExpandableComposite {
    private Logger logger = LoggerFactory.getLogger(SubmissionOptionsComposite.class);
    private AzureSettingStore settingStore;
    private AzureTestPlanRef[] testPlanList;
    private AzureTestPlanRef selectedTestPlan;
    private Combo cbbTestPlan;
    private Button btnFetchTestPlan;
    private Button btnVerifyBuildDefinitionID;
    private Button btnVerifyReleaseDefinitionID;
    private Button chkAutoSubmitTestRun;
    private Button chkSubmitWhenMultiTestPointsWithSameTestCase;
    private Text txtTestRun;
    private Text txtBuildDefinitionID;
    private Text txtReleaseDefinitionID;
    private Button chkIncludeAttachments;
    private Button chkLogFile;
    private Button chkScreenshot;
    private Button chkHTML;
    private Button chkPDF;
    private Button chkCSV;
    private Button radioAttachAllTestExecutions;
    private Button radioAttachFailedTestExecutions;
    private Composite container;
    private Label lblBuildDefinitionIDStatus;
    private Label lblReleaseDefinitionIDStatus;
    private boolean choseTestPlanAsDefault = true;
    private Label blankForReleaseStatus;
    private Label blankForBuildStatus;

    public SubmissionOptionsComposite(Composite parent, AzureSettingStore settingStore) {
        super(parent, StringConstants.GRP_SUBMISSION_OPTIONS, 1, false, 2048);
        this.settingStore = settingStore;
        this.container = (Composite)ComponentBuilder.fromGrid((Composite)this.createControl()).marginLeft(5).fillHorizontal().build();
        this.initializeData();
    }

    public Composite createControl() {
        Composite container = super.createControl();
        Composite testPlanComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3, (int)0).fillHorizontal().build();
        ComponentBuilder.label((Composite)testPlanComposite, (int)0).text(StringConstants.LBL_TEST_PLAN).build();
        this.cbbTestPlan = (Combo)ComponentBuilder.comboBox((Composite)testPlanComposite, (int)2056).gridLayout().width(200).fillHorizontal().applyZoom().build();
        this.btnFetchTestPlan = (Button)ComponentBuilder.button((Composite)testPlanComposite, (int)0).text(StringConstants.BTN_FETCH_TEST_PLAN).build();
        this.chkAutoSubmitTestRun = (Button)ComponentBuilder.button((Composite)container, (int)32).text(StringConstants.CHK_AUTO_SUBMIT_TEST_RUN).build();
        Composite testRunComposite = (Composite)ComponentBuilder.gridContainer((Composite)container, (int)3, (int)0).marginVertical(10).fillHorizontal().build();
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_TEST_RUN_GROUP).colSpan(3).build();
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_TEST_RUN).build();
        this.txtTestRun = (Text)ComponentBuilder.text((Composite)testRunComposite, (int)2048).gridLayout().fillHorizontal().build();
        ComponentBuilder.label((Composite)testRunComposite, (int)0).build();
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_BUILD_DEFINITION_ID).build();
        this.txtBuildDefinitionID = (Text)ComponentBuilder.text((Composite)testRunComposite, (int)2048).gridLayout().fillHorizontal().build();
        this.btnVerifyBuildDefinitionID = (Button)ComponentBuilder.button((Composite)testRunComposite, (int)0).text(StringConstants.BTN_VERIFY).gridLayout().width(100).build();
        this.blankForBuildStatus = (Label)ComponentBuilder.label((Composite)testRunComposite, (int)0).gridLayout().noFillHorizontal().build();
        this.lblBuildDefinitionIDStatus = (Label)ComponentBuilder.label((Composite)testRunComposite, (int)0).gridLayout().colSpan(2).fillHorizontal().build();
        this.setVisibleBuildIDStatusComposite(false);
        ComponentBuilder.label((Composite)testRunComposite, (int)0);
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_NOTE_BUILD_PIPELINE_DEFINITION_ID).colSpan(2).font(FontUtil.ITALIC).build();
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_RELEASE_DEFINITION_ID).build();
        this.txtReleaseDefinitionID = (Text)ComponentBuilder.text((Composite)testRunComposite, (int)2048).gridLayout().fillHorizontal().build();
        this.btnVerifyReleaseDefinitionID = (Button)ComponentBuilder.button((Composite)testRunComposite, (int)0).text(StringConstants.BTN_VERIFY).gridLayout().width(100).build();
        this.blankForReleaseStatus = (Label)ComponentBuilder.label((Composite)testRunComposite, (int)0).gridLayout().noFillHorizontal().build();
        this.lblReleaseDefinitionIDStatus = (Label)ComponentBuilder.label((Composite)testRunComposite, (int)0).gridLayout().fillHorizontal().colSpan(2).build();
        this.setVisibleReleaseIDStatusComposite(false);
        ComponentBuilder.label((Composite)testRunComposite, (int)0);
        ComponentBuilder.label((Composite)testRunComposite, (int)0).text(StringConstants.LBL_NOTE_RELEASE_PIPELINE_DEFINITION_ID).colSpan(2).font(FontUtil.ITALIC).build();
        this.createSendingAttachmentsComposite(container);
        this.chkSubmitWhenMultiTestPointsWithSameTestCase = (Button)ComponentBuilder.button((Composite)container, (int)32).text(StringConstants.CHK_SUBTMIT_WHEN_MULTI_TEST_POINTS_WITH_SAME_TEST_CASE).build();
        this.registerControlModifyListeners();
        return container;
    }

    private void setVisibleBuildIDStatusComposite(boolean isVisible) {
        if (this.lblBuildDefinitionIDStatus == null) {
            return;
        }
        this.lblBuildDefinitionIDStatus.setVisible(isVisible);
        GridData lbLayoutDataBuildDefinitionIDStatus = (GridData)this.lblBuildDefinitionIDStatus.getLayoutData();
        GridData ldBlankForBuildComposite = (GridData)this.blankForBuildStatus.getLayoutData();
        if (lbLayoutDataBuildDefinitionIDStatus != null && ldBlankForBuildComposite != null) {
            lbLayoutDataBuildDefinitionIDStatus.exclude = !isVisible;
            ldBlankForBuildComposite.exclude = !isVisible;
        }
    }

    private void setVisibleReleaseIDStatusComposite(boolean isVisible) {
        if (this.lblReleaseDefinitionIDStatus == null) {
            return;
        }
        this.lblReleaseDefinitionIDStatus.setVisible(isVisible);
        GridData lbLayoutDataBuildDefinitionIDStatus = (GridData)this.lblReleaseDefinitionIDStatus.getLayoutData();
        GridData ldBlankForBuildComposite = (GridData)this.blankForReleaseStatus.getLayoutData();
        if (lbLayoutDataBuildDefinitionIDStatus != null && ldBlankForBuildComposite != null) {
            lbLayoutDataBuildDefinitionIDStatus.exclude = !isVisible;
            ldBlankForBuildComposite.exclude = !isVisible;
        }
    }

    private void createSendingAttachmentsComposite(Composite parent) {
        this.chkIncludeAttachments = new Button(parent, 32);
        this.chkIncludeAttachments.setText(StringConstants.CHK_INCLUDE_ATTACHMENTS);
        Composite executionsAttachmentsOptionsComposite = new Composite(parent, 0);
        GridLayout lAttachmentOptionsComposite = new GridLayout();
        lAttachmentOptionsComposite.marginLeft = 10;
        lAttachmentOptionsComposite.marginBottom = 5;
        executionsAttachmentsOptionsComposite.setLayout((Layout)lAttachmentOptionsComposite);
        executionsAttachmentsOptionsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.radioAttachAllTestExecutions = new Button(executionsAttachmentsOptionsComposite, 16);
        this.radioAttachAllTestExecutions.setText(StringConstants.RAD_ATTACH_FOR_ALL_TEST_EXECUTIONS);
        this.radioAttachFailedTestExecutions = new Button(executionsAttachmentsOptionsComposite, 16);
        this.radioAttachFailedTestExecutions.setText(StringConstants.RAD_ATTACH_FOR_FAILED_TEST_EXECUTIONS);
        this.chkLogFile = new Button(executionsAttachmentsOptionsComposite, 32);
        this.chkLogFile.setText(StringConstants.CHK_LOG_FILE);
        this.chkScreenshot = new Button(executionsAttachmentsOptionsComposite, 32);
        this.chkScreenshot.setText(StringConstants.CHK_SCREENSHOTS);
        this.chkHTML = new Button(executionsAttachmentsOptionsComposite, 32);
        this.chkHTML.setText(StringConstants.CHK_HTML_REPORT);
        this.chkPDF = new Button(executionsAttachmentsOptionsComposite, 32);
        this.chkPDF.setText(StringConstants.CHK_PDF_REPORT);
        this.chkCSV = new Button(executionsAttachmentsOptionsComposite, 32);
        this.chkCSV.setText(StringConstants.CHK_CSV_REPORT);
    }

    public void enableAttachmentsComposite(boolean isEnabled) {
        if (!isEnabled) {
            this.setEnableAttachmentsComposite(false);
            return;
        }
        this.setEnableAttachmentsComposite(this.chkIncludeAttachments.getSelection());
    }

    private void setEnableAttachmentsComposite(boolean isEnabled) {
        this.radioAttachAllTestExecutions.setEnabled(isEnabled);
        this.radioAttachFailedTestExecutions.setEnabled(isEnabled);
        this.chkLogFile.setEnabled(isEnabled);
        this.chkScreenshot.setEnabled(isEnabled);
        this.chkHTML.setEnabled(isEnabled);
        this.chkPDF.setEnabled(isEnabled);
        this.chkCSV.setEnabled(isEnabled);
    }

    public void addFetchTestPlanListener(SelectionAdapter listener) {
        this.btnFetchTestPlan.addSelectionListener((SelectionListener)listener);
    }

    public void addVerifyBuildDefinitionIDListener(SelectionAdapter listener) {
        this.btnVerifyBuildDefinitionID.addSelectionListener((SelectionListener)listener);
    }

    public void addVerifyReleaseDefinitionIDListener(SelectionAdapter listener) {
        this.btnVerifyReleaseDefinitionID.addSelectionListener((SelectionListener)listener);
    }

    public void initializeData() {
        this.selectedTestPlan = this.settingStore.getAzureTestPlan();
        this.testPlanList = this.settingStore.getFetchedAzureTestPlanList();
        this.updateTestPlanComboBox(this.testPlanList, false, true);
        this.chkAutoSubmitTestRun.setSelection(this.settingStore.isAutoSubmitTestRunEnabled());
        this.chkSubmitWhenMultiTestPointsWithSameTestCase.setSelection(this.settingStore.isSubmitMultipleTestPointsEnabled());
        this.txtTestRun.setText(this.settingStore.getTestRunName());
        int storedBuildDefID = this.settingStore.getBuildDefinitionId();
        String buildDefIDString = storedBuildDefID < 0 ? "" : Integer.toString(storedBuildDefID);
        this.txtBuildDefinitionID.setText(buildDefIDString);
        int storedReleaseDefID = this.settingStore.getReleaseDefinitionId();
        String releaseDefIDString = storedReleaseDefID < 0 ? "" : Integer.toString(storedReleaseDefID);
        this.txtReleaseDefinitionID.setText(releaseDefIDString);
        this.chkIncludeAttachments.setSelection(this.settingStore.isIncludeAttachmentEnabled());
        if (this.settingStore.getAttachmentSendingType().equals((Object)AzureAttachmentSendingType.SEND_ALL)) {
            this.radioAttachAllTestExecutions.setSelection(true);
        } else {
            this.radioAttachFailedTestExecutions.setSelection(true);
        }
        List reportFormatTypeList = this.settingStore.getAttachmentFileTypes();
        for (ReportFormatType type : reportFormatTypeList) {
            switch (type) {
                case LOG: {
                    this.chkLogFile.setSelection(true);
                    break;
                }
                case PNG: {
                    this.chkScreenshot.setSelection(true);
                    break;
                }
                case HTML: {
                    this.chkHTML.setSelection(true);
                    break;
                }
                case PDF: {
                    this.chkPDF.setSelection(true);
                    break;
                }
                case CSV: {
                    this.chkCSV.setSelection(true);
                    break;
                }
            }
        }
        this.setEnableAttachmentsComposite(this.chkIncludeAttachments.getSelection());
    }

    public void registerControlModifyListeners() {
        this.btnVerifyBuildDefinitionID.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SubmissionOptionsComposite.this.clearBuildDefinitionIDMessage();
            }
        });
        this.btnVerifyReleaseDefinitionID.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                SubmissionOptionsComposite.this.clearReleaseDefinitionIDMessage();
            }
        });
        this.cbbTestPlan.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SubmissionOptionsComposite.this.testPlanList == null || SubmissionOptionsComposite.this.cbbTestPlan.getSelectionIndex() < 0) {
                    return;
                }
                AzureTestPlanRef newSelectedTestPlan = SubmissionOptionsComposite.this.testPlanList[SubmissionOptionsComposite.this.cbbTestPlan.getSelectionIndex()];
                if (newSelectedTestPlan == SubmissionOptionsComposite.this.selectedTestPlan) {
                    return;
                }
                SubmissionOptionsComposite.this.choseTestPlanAsDefault = false;
                SubmissionOptionsComposite.this.selectedTestPlan = newSelectedTestPlan;
            }
        });
        this.chkIncludeAttachments.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SubmissionOptionsComposite.this.setEnableAttachmentsComposite(SubmissionOptionsComposite.this.chkIncludeAttachments.getSelection());
            }
        });
    }

    public void saveToSettingStore() throws IOException {
        this.clearBuildDefinitionIDMessage();
        this.clearReleaseDefinitionIDMessage();
        if (this.testPlanList != null && this.testPlanList.length > 0) {
            this.settingStore.setFetchedAzureTestPlanList(this.testPlanList);
            this.settingStore.setAzureTestPlanRef(this.testPlanList[this.cbbTestPlan.getSelectionIndex()]);
        }
        this.settingStore.setAutoSubmitTestRun(this.chkAutoSubmitTestRun.getSelection());
        this.settingStore.setSubmitMultipleTestPoints(this.chkSubmitWhenMultiTestPointsWithSameTestCase.getSelection());
        this.settingStore.setTestRunName(this.txtTestRun.getText());
        String rawBuildDefinitionID = this.txtBuildDefinitionID.getText();
        if (StringUtils.isBlank((CharSequence)rawBuildDefinitionID)) {
            this.settingStore.setBuildDefinitionId(-1);
        } else {
            this.settingStore.setBuildDefinitionId(Integer.parseInt(rawBuildDefinitionID));
        }
        String rawReleaseDefinitionID = this.txtReleaseDefinitionID.getText();
        if (StringUtils.isBlank((CharSequence)rawReleaseDefinitionID)) {
            this.settingStore.setReleaseDefinitionId(-1);
        } else {
            this.settingStore.setReleaseDefinitionId(Integer.parseInt(rawReleaseDefinitionID));
        }
        this.settingStore.setIncludeAttachmentEnabled(this.chkIncludeAttachments.getSelection());
        if (this.radioAttachAllTestExecutions.getSelection()) {
            this.settingStore.setAttachmentSendingType(AzureAttachmentSendingType.SEND_ALL);
        } else {
            this.settingStore.setAttachmentSendingType(AzureAttachmentSendingType.SEND_IF_FAILS);
        }
        ArrayList<ReportFormatType> reportFormatTypeList = new ArrayList<ReportFormatType>();
        if (this.chkLogFile.getSelection()) {
            reportFormatTypeList.add(ReportFormatType.LOG);
        }
        if (this.chkScreenshot.getSelection()) {
            reportFormatTypeList.add(ReportFormatType.PNG);
        }
        if (this.chkHTML.getSelection()) {
            reportFormatTypeList.add(ReportFormatType.HTML);
        }
        if (this.chkPDF.getSelection()) {
            reportFormatTypeList.add(ReportFormatType.PDF);
        }
        if (this.chkCSV.getSelection()) {
            reportFormatTypeList.add(ReportFormatType.CSV);
        }
        this.settingStore.setAttachmentFileTypes(reportFormatTypeList);
    }

    public void reset(AzureCredential credential, String projectId, boolean isSilent) {
        this.txtTestRun.setText(this.settingStore.getDefaultTestRunName());
        this.txtBuildDefinitionID.setText("");
        this.txtReleaseDefinitionID.setText("");
        this.updateTestPlanComboBox(credential, projectId, isSilent);
    }

    private AzureTestPlanRef[] fetchTestPlans(AzureCredential credential, String projectId) throws AzureApiException {
        if (credential != null && StringUtils.isNotBlank((CharSequence)projectId)) {
            AzureTestPlansRef testPlans = AzureIntegrationRequest.getAllTestPlans((AzureCredential)credential, (String)projectId);
            return testPlans.getValue();
        }
        return null;
    }

    public boolean hasEditted() {
        if (this.cbbTestPlan.getSelectionIndex() >= 0 && !this.choseTestPlanAsDefault) {
            return true;
        }
        if (!this.txtTestRun.getText().equals(this.settingStore.getDefaultTestRunName())) {
            return true;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.txtBuildDefinitionID.getText())) {
            return true;
        }
        return StringUtils.isNotEmpty((CharSequence)this.txtReleaseDefinitionID.getText());
    }

    public void updateTestPlanComboBox(AzureTestPlanRef[] testPlanList, boolean shouldDropDownCombobox, boolean isSilent) {
        if (testPlanList == null || testPlanList.length <= 0) {
            if (!isSilent) {
                MessageDialog.openWarning(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)StringConstants.MSG_NO_TEST_PLAN);
            }
            this.testPlanList = new AzureTestPlanRef[0];
            this.cbbTestPlan.setItems(new String[0]);
            this.cbbTestPlan.select(-1);
            this.choseTestPlanAsDefault = true;
            this.selectedTestPlan = null;
            return;
        }
        this.testPlanList = testPlanList;
        String[] testPlanNames = (String[])Arrays.asList(testPlanList).stream().map(testPlan -> testPlan.getName()).toArray(String[]::new);
        this.cbbTestPlan.setItems(testPlanNames);
        int selectedIndex = this.getTestPlanIndex(this.testPlanList, this.selectedTestPlan);
        this.cbbTestPlan.select(selectedIndex);
        if (this.selectedTestPlan != null && this.selectedTestPlan.getId() == this.testPlanList[selectedIndex].getId() && shouldDropDownCombobox) {
            this.dropDownTestPlanCombobox();
        } else {
            this.selectedTestPlan = this.testPlanList[selectedIndex];
        }
    }

    public void dropDownTestPlanCombobox() {
        if (OSUtil.isWindows()) {
            this.cbbTestPlan.setListVisible(true);
        }
    }

    public void updateTestPlanComboBox(AzureCredential credential, String projectId, boolean isSilent) {
        try {
            this.testPlanList = this.fetchTestPlans(credential, projectId);
            this.updateTestPlanComboBox(this.testPlanList, false, isSilent);
        }
        catch (AzureApiException exception) {
            this.logger.error(exception.getMessage());
        }
    }

    private int getTestPlanIndex(AzureTestPlanRef[] testPlanList, AzureTestPlanRef selectedTestPlan) {
        if (testPlanList == null) {
            this.choseTestPlanAsDefault = true;
            return -1;
        }
        if (selectedTestPlan == null) {
            this.choseTestPlanAsDefault = true;
            return 0;
        }
        int i = 0;
        while (i < testPlanList.length) {
            if (testPlanList[i].getId() == selectedTestPlan.getId()) {
                this.choseTestPlanAsDefault = i == 0;
                return i;
            }
            ++i;
        }
        this.choseTestPlanAsDefault = true;
        return 0;
    }

    protected void expandCollapseBody() {
        super.expandCollapseBody();
        if (this.container == null) {
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Composite composite = SubmissionOptionsComposite.this.container;
                int count = 0;
                do {
                    ScrolledComposite scrolledComposite;
                    ++count;
                    if (!((composite = composite.getParent()) instanceof ScrolledComposite) || !(scrolledComposite = (ScrolledComposite)composite).getExpandHorizontal() && !scrolledComposite.getExpandVertical()) continue;
                    scrolledComposite.setMinSize(scrolledComposite.getContent().computeSize(-1, -1, true));
                    Shell shell = scrolledComposite.getShell();
                    Point defaultSize = SubmissionOptionsComposite.this.container.getShell().computeSize(-1, -1);
                    int height = shell.getClientArea().height;
                    int width = shell.getClientArea().width;
                    if (width < defaultSize.x) {
                        width = -1;
                    }
                    if (height < defaultSize.y) {
                        height = -1;
                    }
                    Point newPoint = shell.computeSize(width, height, true);
                    int maximumHeight = shell.getDisplay().getClientArea().height - 50;
                    if (shell.getMaximized()) {
                        return;
                    }
                    if (newPoint.y > maximumHeight) {
                        newPoint.y = maximumHeight;
                    }
                    shell.setSize(newPoint);
                    return;
                } while (!(composite instanceof ScrolledComposite) && count <= 5);
            }
        });
    }

    public boolean verifyBuildDefinitionID(AzureCredential credential, AzureProjectRef project) throws AzureApiException {
        this.clearBuildDefinitionIDMessage();
        try {
            if (!this.checkValidDefinitionID(this.txtBuildDefinitionID)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidBuildDefinitionIDMessage();
            return false;
        }
        int definitionId = Integer.parseInt(this.txtBuildDefinitionID.getText().trim());
        ShallowReference fetchedBuildDefinition = AzureIntegrationRequest.getBuildDefinition((AzureCredential)credential, (String)project.getId(), (int)definitionId);
        if (fetchedBuildDefinition == null) {
            this.showInvalidBuildDefinitionIDMessage();
            return false;
        }
        if (fetchedBuildDefinition.getId() == definitionId) {
            this.showValidBuildDefinitionIDMessage();
            return true;
        }
        this.showInvalidBuildDefinitionIDMessage();
        return false;
    }

    public boolean verifyReleaseDefinitionID(AzureCredential credential, AzureProjectRef project) throws AzureApiException {
        this.clearReleaseDefinitionIDMessage();
        try {
            if (!this.checkValidDefinitionID(this.txtReleaseDefinitionID)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidReleaseDefinitionIDMessage();
            return false;
        }
        int definitionId = Integer.parseInt(this.txtReleaseDefinitionID.getText().trim());
        AzureReleaseDefinitionRef fetchedReleaseDefinition = AzureIntegrationRequest.getReleaseDefinition((AzureCredential)credential, (String)project.getId(), (int)definitionId);
        if (fetchedReleaseDefinition == null) {
            this.showInvalidReleaseDefinitionIDMessage();
            return false;
        }
        if (fetchedReleaseDefinition.getId() == definitionId) {
            this.showValidReleaseDefinitionIDMessage();
            return true;
        }
        this.showInvalidReleaseDefinitionIDMessage();
        return false;
    }

    public boolean checkValidationBeforeSaving(AzureCredential credential, AzureProjectRef project) {
        block11: {
            if (this.cbbTestPlan.getSelectionIndex() < 0) {
                MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(String.valueOf(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS) + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_TEST_PLAN_IS_NULL));
                return false;
            }
            if (project != null && !StringUtils.isEmpty((CharSequence)project.getId())) break block11;
            return false;
        }
        try {
            AzureTestPlansRef fetchedTestPlans = AzureIntegrationRequest.getAllTestPlans((AzureCredential)credential, (String)project.getId());
            boolean isValidTestPlan = false;
            if (fetchedTestPlans != null && fetchedTestPlans.getCount() > 0) {
                AzureTestPlanRef[] azureTestPlanRefArray = fetchedTestPlans.getValue();
                int n = azureTestPlanRefArray.length;
                int n2 = 0;
                while (n2 < n) {
                    AzureTestPlanRef testPlan = azureTestPlanRefArray[n2];
                    if (testPlan.getId() == this.selectedTestPlan.getId()) {
                        isValidTestPlan = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!isValidTestPlan) {
                MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(String.valueOf(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS) + StringConstants.MSG_ERROR_INVALID_SELECTED_TEST_PLAN));
                return false;
            }
        }
        catch (AzureApiException azureApiException) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.txtTestRun.getText())) {
            MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(String.valueOf(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS) + StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS_TEST_RUN_IS_NULL));
            return false;
        }
        try {
            this.checkValidDefinitionID(this.txtBuildDefinitionID);
            this.checkValidDefinitionID(this.txtReleaseDefinitionID);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError(null, (String)StringConstants.AZURE_DEVOPS_NAME, (String)(String.valueOf(StringConstants.MSG_ERROR_BEFORE_SAVING_SETTINGS) + StringConstants.MSG_ERROR_INVALID_BUILD_DEFINITION_ID));
            return false;
        }
        return true;
    }

    private boolean checkValidDefinitionID(Text txtDefinitionID) throws NumberFormatException {
        String rawDefinitionID = txtDefinitionID.getText().trim();
        if (StringUtils.isNotEmpty((CharSequence)rawDefinitionID)) {
            int parsedDefinitionID = Integer.parseInt(rawDefinitionID);
            if (parsedDefinitionID < 0) {
                throw new NumberFormatException();
            }
        } else {
            return false;
        }
        return true;
    }

    public void clearBuildDefinitionIDMessage() {
        this.lblBuildDefinitionIDStatus.setText("");
        this.setVisibleBuildIDStatusComposite(false);
        this.lblBuildDefinitionIDStatus.requestLayout();
    }

    public void showValidBuildDefinitionIDMessage() {
        this.setVisibleBuildIDStatusComposite(true);
        this.lblBuildDefinitionIDStatus.setForeground(this.lblBuildDefinitionIDStatus.getDisplay().getSystemColor(6));
        this.lblBuildDefinitionIDStatus.setText(StringConstants.MSG_VALID_DEFINITION_ID);
        this.lblBuildDefinitionIDStatus.requestLayout();
    }

    public void showInvalidBuildDefinitionIDMessage() {
        this.setVisibleBuildIDStatusComposite(true);
        this.lblBuildDefinitionIDStatus.setForeground(this.lblBuildDefinitionIDStatus.getDisplay().getSystemColor(4));
        this.lblBuildDefinitionIDStatus.setText(StringConstants.MSG_INVALID_DEFINITION_ID);
        this.lblBuildDefinitionIDStatus.requestLayout();
    }

    public void clearReleaseDefinitionIDMessage() {
        this.lblReleaseDefinitionIDStatus.setText("");
        this.setVisibleReleaseIDStatusComposite(false);
        this.lblReleaseDefinitionIDStatus.requestLayout();
    }

    public void showValidReleaseDefinitionIDMessage() {
        this.setVisibleReleaseIDStatusComposite(true);
        this.lblReleaseDefinitionIDStatus.setForeground(this.lblReleaseDefinitionIDStatus.getDisplay().getSystemColor(6));
        this.lblReleaseDefinitionIDStatus.setText(StringConstants.MSG_VALID_DEFINITION_ID);
        this.lblReleaseDefinitionIDStatus.requestLayout();
    }

    public void showInvalidReleaseDefinitionIDMessage() {
        this.setVisibleReleaseIDStatusComposite(true);
        this.lblReleaseDefinitionIDStatus.setForeground(this.lblReleaseDefinitionIDStatus.getDisplay().getSystemColor(4));
        this.lblReleaseDefinitionIDStatus.setText(StringConstants.MSG_INVALID_DEFINITION_ID);
        this.lblReleaseDefinitionIDStatus.requestLayout();
    }
}

