/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.TimeZone;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPTZ;
import oracle.sql.TIMEZONETAB;
import oracle.sql.ZONEIDMAP;

class TimestamptzAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 13;
    TimestampTzConverter tstzConverter = null;
    static int OFFSET_HOUR = 20;
    static int OFFSET_MINUTE = 60;
    static byte REGIONIDBIT = (byte)-128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl) throws SQLException {
        super(Representation.TIMESTAMPTZ, oracleStatement, 13, bl);
        this.init(oracleStatement, 181, 181, s2, bl);
        this.initForDataAccess(n3, n2, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    TimestamptzAccessor(OracleStatement oracleStatement, int n2, boolean bl, int n3, int n4, int n5, int n6, int n7, short s2) throws SQLException {
        super(Representation.TIMESTAMPTZ, oracleStatement, 13, false);
        this.init(oracleStatement, 181, 181, s2, false);
        this.initForDescribe(181, n2, bl, n3, n4, n5, n6, n7, s2, null);
        this.initForDataAccess(0, n2, null);
        this.tstzConverter = this.statement.connection.timestamptzInGmt ? new GmtTimestampTzConverter() : new OldTimestampTzConverter();
    }

    @Override
    String getString(int n2) throws SQLException {
        boolean bl;
        int n3;
        int n4;
        String string;
        Object object;
        if (this.isNull(n2)) {
            return null;
        }
        int n5 = 0;
        this.getBytesInternal(n2, this.tmpBytes);
        if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
            n5 = TimestamptzAccessor.getHighOrderbits(this.oracleTZ1(this.tmpBytes));
            object = this.statement.connection.getTIMEZONETAB();
            if (((TIMEZONETAB)object).checkID(n5 += TimestamptzAccessor.getLowOrderbits(this.oracleTZ2(this.tmpBytes)))) {
                ((TIMEZONETAB)object).updateTable(this.statement.connection, n5);
            }
            string = ZONEIDMAP.getRegion(n5);
        } else {
            int n6 = this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR;
            n4 = Math.abs(this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
            string = "GMT" + (n6 < 0 ? "" : "+") + n6 + (n4 < 10 ? ":0" : ":") + n4;
        }
        object = (Calendar)this.statement.getGMTCalendar().clone();
        n4 = this.oracleYear(this.tmpBytes);
        ((Calendar)object).set(1, n4);
        ((Calendar)object).set(2, this.oracleMonth(this.tmpBytes));
        ((Calendar)object).set(5, this.oracleDay(this.tmpBytes));
        ((Calendar)object).set(11, this.oracleHour(this.tmpBytes));
        ((Calendar)object).set(12, this.oracleMin(this.tmpBytes));
        ((Calendar)object).set(13, this.oracleSec(this.tmpBytes));
        ((Calendar)object).set(14, 0);
        if ((this.oracleTZ1(this.tmpBytes) & REGIONIDBIT) != 0) {
            TIMEZONETAB tIMEZONETAB = this.statement.connection.getTIMEZONETAB();
            n3 = tIMEZONETAB.getOffset((Calendar)object, n5);
            ((Calendar)object).add(14, n3);
        } else {
            ((Calendar)object).add(10, this.oracleTZ1(this.tmpBytes) - OFFSET_HOUR);
            ((Calendar)object).add(12, this.oracleTZ2(this.tmpBytes) - OFFSET_MINUTE);
        }
        n4 = ((Calendar)object).get(1);
        int n7 = ((Calendar)object).get(2) + 1;
        n3 = ((Calendar)object).get(5);
        int n8 = ((Calendar)object).get(11);
        int n9 = ((Calendar)object).get(12);
        int n10 = ((Calendar)object).get(13);
        boolean bl2 = bl = n8 < 12;
        if (string.length() > 3 && string.startsWith("GMT")) {
            string = string.substring(3);
        }
        int n11 = this.oracleNanos(this.tmpBytes);
        return this.toText(n4, n7, n3, n8, n9, n10, n11, bl, string);
    }

    @Override
    Date getDate(int n2) throws SQLException {
        return this.tstzConverter.getDate(n2);
    }

    @Override
    Date getDate(int n2, Calendar calendar) throws SQLException {
        return this.getDate(n2);
    }

    @Override
    Time getTime(int n2) throws SQLException {
        return this.tstzConverter.getTime(n2);
    }

    @Override
    Time getTime(int n2, Calendar calendar) throws SQLException {
        return this.getTime(n2);
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        return this.tstzConverter.getTimestamp(n2);
    }

    @Override
    Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        return this.getTimestamp(n2);
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.tstzConverter.getObject(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.tstzConverter.getOracleObject(n2);
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = this.tstzConverter.getTIMESTAMPTZ(n2);
        if (tIMESTAMPTZ == null) {
            return null;
        }
        return oracle.sql.TIMESTAMPTZ.toDATE(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = this.tstzConverter.getTIMESTAMPTZ(n2);
        if (tIMESTAMPTZ == null) {
            return null;
        }
        return oracle.sql.TIMESTAMPTZ.toTIMESTAMP(this.statement.connection, tIMESTAMPTZ.getBytes());
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        return this.tstzConverter.getTIMESTAMPTZ(n2);
    }

    static int setHighOrderbits(int n2) {
        return (n2 & 0x1FC0) >> 6;
    }

    static int setLowOrderbits(int n2) {
        return (n2 & 0x3F) << 2;
    }

    static int getHighOrderbits(int n2) {
        return (n2 & 0x7F) << 6;
    }

    static int getLowOrderbits(int n2) {
        return (n2 & 0xFC) >> 2;
    }

    abstract class TimestampTzConverter {
        TimestampTzConverter() {
        }

        abstract Date getDate(int var1) throws SQLException;

        abstract Time getTime(int var1) throws SQLException;

        abstract Timestamp getTimestamp(int var1) throws SQLException;

        Object getObject(int n2) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        Datum getOracleObject(int n2) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        Object getObject(int n2, Map map) throws SQLException {
            return this.getTIMESTAMPTZ(n2);
        }

        abstract TIMESTAMPTZ getTIMESTAMPTZ(int var1) throws SQLException;
    }

    class GmtTimestampTzConverter
    extends TimestampTzConverter {
        GmtTimestampTzConverter() {
        }

        @Override
        Date getDate(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            Calendar calendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n3 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n3);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            long l2 = calendar.getTimeInMillis();
            return new Date(l2);
        }

        @Override
        Time getTime(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            Calendar calendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n3 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n3);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            return new Time(calendar.getTimeInMillis());
        }

        @Override
        Timestamp getTimestamp(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            Calendar calendar = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n3 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n3);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            long l2 = calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(l2);
            int n4 = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            timestamp.setNanos(n4);
            return timestamp;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(n2));
        }
    }

    class OldTimestampTzConverter
    extends TimestampTzConverter {
        OldTimestampTzConverter() {
        }

        @Override
        Date getDate(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n3 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n3);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int n4 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n4);
                }
                int n5 = tIMEZONETAB.getOffset(calendar, n4);
                boolean bl = timeZone.inDaylightTime(calendar.getTime());
                boolean bl2 = timeZone.inDaylightTime(new java.util.Date(calendar.getTimeInMillis() + (long)n5));
                if (!bl && bl2) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (bl && !bl2) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n5 / 3600000);
                calendar.add(12, n5 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            return new Date(l2);
        }

        @Override
        Time getTime(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n3 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n3);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int n4 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n4 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n4);
                }
                int n5 = tIMEZONETAB.getOffset(calendar, n4);
                boolean bl = timeZone.inDaylightTime(calendar.getTime());
                boolean bl2 = timeZone.inDaylightTime(new java.util.Date(calendar.getTimeInMillis() + (long)n5));
                if (!bl && bl2) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (bl && !bl2) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n5 / 3600000);
                calendar.add(12, n5 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            return new Time(l2);
        }

        @Override
        Timestamp getTimestamp(int n2) throws SQLException {
            int n3;
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            TimeZone timeZone = TimestamptzAccessor.this.statement.getDefaultTimeZone();
            Calendar calendar = Calendar.getInstance(timeZone);
            Calendar calendar2 = (Calendar)TimestamptzAccessor.this.statement.getGMTCalendar().clone();
            TimestamptzAccessor.this.getBytesInternal(n2, TimestamptzAccessor.this.tmpBytes);
            int n4 = TimestamptzAccessor.this.oracleYear(TimestamptzAccessor.this.tmpBytes);
            calendar.set(1, n4);
            calendar.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar.set(14, 0);
            calendar2.set(1, n4);
            calendar2.set(2, TimestamptzAccessor.this.oracleMonth(TimestamptzAccessor.this.tmpBytes));
            calendar2.set(5, TimestamptzAccessor.this.oracleDay(TimestamptzAccessor.this.tmpBytes));
            calendar2.set(11, TimestamptzAccessor.this.oracleHour(TimestamptzAccessor.this.tmpBytes));
            calendar2.set(12, TimestamptzAccessor.this.oracleMin(TimestamptzAccessor.this.tmpBytes));
            calendar2.set(13, TimestamptzAccessor.this.oracleSec(TimestamptzAccessor.this.tmpBytes));
            calendar2.set(14, 0);
            if ((TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) & REGIONIDBIT) != 0) {
                int n5 = TimestamptzAccessor.getHighOrderbits(TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes));
                TIMEZONETAB tIMEZONETAB = TimestamptzAccessor.this.statement.connection.getTIMEZONETAB();
                if (tIMEZONETAB.checkID(n5 += TimestamptzAccessor.getLowOrderbits(TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes)))) {
                    tIMEZONETAB.updateTable(TimestamptzAccessor.this.statement.connection, n5);
                }
                int n6 = tIMEZONETAB.getOffset(calendar2, n5);
                n3 = timeZone.inDaylightTime(calendar.getTime()) ? 1 : 0;
                boolean bl = timeZone.inDaylightTime(new java.util.Date(calendar.getTimeInMillis() + (long)n6));
                if (n3 == 0 && bl) {
                    calendar.add(14, -1 * timeZone.getDSTSavings());
                } else if (n3 != 0 && !bl) {
                    calendar.add(14, timeZone.getDSTSavings());
                }
                calendar.add(10, n6 / 3600000);
                calendar.add(12, n6 % 3600000 / 60000);
            } else {
                calendar.add(10, TimestamptzAccessor.this.oracleTZ1(TimestamptzAccessor.this.tmpBytes) - OFFSET_HOUR);
                calendar.add(12, TimestamptzAccessor.this.oracleTZ2(TimestamptzAccessor.this.tmpBytes) - OFFSET_MINUTE);
            }
            long l2 = calendar.getTimeInMillis();
            Timestamp timestamp = new Timestamp(l2);
            n3 = TimestamptzAccessor.this.oracleNanos(TimestamptzAccessor.this.tmpBytes);
            timestamp.setNanos(n3);
            return timestamp;
        }

        @Override
        TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
            if (TimestamptzAccessor.this.isNull(n2)) {
                return null;
            }
            return new TIMESTAMPTZ(TimestamptzAccessor.this.getBytesInternal(n2));
        }
    }
}

