/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.handler;

import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.explorer.handlers.deletion.IDeleteEntityHandler;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.TestSuiteCollectionController;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.e4.core.services.events.IEventBroker;

public class DeleteExecutionProfileHandler
implements IDeleteEntityHandler {
    @Inject
    private IEventBroker eventBroker;

    public Class<? extends ITreeEntity> entityType() {
        return ProfileTreeEntity.class;
    }

    public boolean execute(ITreeEntity treeEntity, IProgressMonitor monitor) {
        if (!(treeEntity instanceof ProfileTreeEntity)) {
            return false;
        }
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        ExecutionProfileEntity executionProfile = null;
        try {
            executionProfile = (ExecutionProfileEntity)treeEntity.getObject();
            GlobalVariableController.getInstance().deleteExecutionProfile(executionProfile);
            if (executionProfile.isDefaultProfile()) {
                ExecutionProfileEntity defaultProfile = GlobalVariableController.getInstance().getExecutionProfile("default", project);
                defaultProfile.setDefaultProfile(true);
                GlobalVariableController.getInstance().updateExecutionProfile(defaultProfile);
                this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)treeEntity.getParent());
            }
            List updatedTestSuiteCollections = TestSuiteCollectionController.getInstance().updateProfileNameInAllTestSuiteCollections(project, executionProfile.getName(), "default");
            this.eventBroker.post("EXECUTION_PROFILE/DELETED", (Object)executionProfile);
            updatedTestSuiteCollections.forEach(tsc -> {
                boolean bl = this.eventBroker.post("TEST_SUITE_COLLECTION/UPDATED", (Object)new Object[]{tsc.getId(), tsc});
            });
        }
        catch (Exception exception) {}
        return true;
    }
}

