/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.handler;

import com.kms.katalon.composer.components.impl.dialogs.MultiStatusErrorDialog;
import com.kms.katalon.composer.components.impl.handler.CommonExplorerHandler;
import com.kms.katalon.composer.components.impl.tree.ProfileTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.core.util.internal.ExceptionsUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;

public class SetDefaultExecutionProfileHandler
extends CommonExplorerHandler {
    @Inject
    private IEventBroker eventBroker;

    public boolean canExecute() {
        ExecutionProfileEntity selectedProfile;
        ITreeEntity firstSelection = this.getFirstSelection();
        if (firstSelection == null || !(firstSelection instanceof ProfileTreeEntity)) {
            return false;
        }
        try {
            selectedProfile = (ExecutionProfileEntity)firstSelection.getObject();
        }
        catch (Exception exception) {
            return false;
        }
        return !selectedProfile.isDefaultProfile();
    }

    public void execute() {
        ProfileTreeEntity selectedProfileTree = (ProfileTreeEntity)this.getFirstSelection();
        ExecutionProfileEntity selectedProfile = null;
        try {
            selectedProfile = selectedProfileTree.getObject();
        }
        catch (Exception exception) {}
        if (selectedProfile == null) {
            return;
        }
        try {
            selectedProfile.setDefaultProfile(true);
            GlobalVariableController.getInstance().updateExecutionProfile(selectedProfile);
            String selectedProfileName = selectedProfile.getName();
            ProjectEntity project = ProjectController.getInstance().getCurrentProject();
            GlobalVariableController.getInstance().getAllGlobalVariableCollections(project).stream().filter(profile -> !profile.getName().equals(selectedProfileName)).forEach(profile -> {
                profile.setDefaultProfile(false);
                try {
                    GlobalVariableController.getInstance().updateExecutionProfile(profile);
                }
                catch (ControllerException exception) {
                    LoggerSingleton.logError((Throwable)exception);
                }
            });
            this.eventBroker.post("EXPLORER/REFRESH_TREE_ENTITY", (Object)selectedProfileTree.getParent());
        }
        catch (Exception e) {
            MultiStatusErrorDialog.showErrorDialog((String)MessageFormat.format("Unable to set default execution profile to '{0}'", selectedProfile.getName()), (String)e.getMessage(), (String)ExceptionsUtil.getStackTraceForThrowable((Throwable)e));
        }
    }

    private ITreeEntity getFirstSelection() {
        List selectedElements = this.getElementSelection(ITreeEntity.class);
        if (selectedElements == null) {
            return null;
        }
        return selectedElements.size() == 1 ? (ITreeEntity)selectedElements.get(0) : null;
    }
}

