/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.global.part;

import com.kms.katalon.composer.components.impl.constants.ImageConstants;
import com.kms.katalon.composer.components.impl.util.ControlUtils;
import com.kms.katalon.composer.components.impl.util.EntityPartUtil;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.operation.OperationExecutor;
import com.kms.katalon.composer.components.part.SavableCompositePart;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.composer.components.util.ColumnViewerUtil;
import com.kms.katalon.composer.global.constants.StringConstants;
import com.kms.katalon.composer.global.dialog.GlobalVariableBuilderDialog;
import com.kms.katalon.composer.global.part.ExecutionProfileCompositePart;
import com.kms.katalon.composer.global.provider.TableViewerProvider;
import com.kms.katalon.composer.global.support.GlobalVariableEdittingSupport;
import com.kms.katalon.composer.parts.CPart;
import com.kms.katalon.controller.GlobalVariableController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.webui.util.OSUtil;
import com.kms.katalon.entity.global.ExecutionProfileEntity;
import com.kms.katalon.entity.global.GlobalVariableEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.tracking.service.Trackings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class GlobalVariablePart
extends CPart
implements TableViewerProvider,
EventHandler,
SavableCompositePart {
    private Table table;
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private EPartService partService;
    private TableViewer tableViewer;
    private ToolItem tltmAdd;
    private ToolItem tltmRemove;
    private ToolItem tltmClear;
    private ToolItem tltmEdit;
    private ToolItem tltmMoveUp;
    private ToolItem tltmMoveDown;
    private MPart mpart;
    private Composite composite;
    private Map<GlobalVariableEntity, String> needToUpdateVariables = new HashMap<GlobalVariableEntity, String>();
    private List<GlobalVariableEntity> globalVariables = new ArrayList<GlobalVariableEntity>();
    private ExecutionProfileEntity executionProfileEntity;
    private ExecutionProfileCompositePart parentExecutionProfileCompositePart;

    @PostConstruct
    public void init(Composite parent, MPart mpart) {
        MCompositePart compositePart;
        this.mpart = mpart;
        this.executionProfileEntity = (ExecutionProfileEntity)mpart.getObject();
        if (mpart.getParent().getParent() instanceof MGenericTile && (MGenericTile)mpart.getParent().getParent() instanceof MCompositePart && (compositePart = (MCompositePart)((MGenericTile)mpart.getParent().getParent())).getObject() instanceof ExecutionProfileCompositePart) {
            this.parentExecutionProfileCompositePart = (ExecutionProfileCompositePart)compositePart.getObject();
        }
        this.initialize(mpart, this.partService);
        this.createComposite(parent);
        this.registerEventListeners();
    }

    private void createComposite(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setLayout((Layout)new GridLayout(1, false));
        Composite compositeToolbar = new Composite(this.composite, 0);
        compositeToolbar.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        GridLayout gl_compositeToolbar = new GridLayout(1, false);
        gl_compositeToolbar.marginWidth = 0;
        gl_compositeToolbar.marginHeight = 0;
        compositeToolbar.setLayout((Layout)gl_compositeToolbar);
        compositeToolbar.setBackground(ColorUtil.getCompositeBackgroundColor());
        ToolBar toolBar = new ToolBar(compositeToolbar, 0x820000);
        toolBar.setForeground(ColorUtil.getToolBarForegroundColor());
        this.tltmAdd = new ToolItem(toolBar, 0);
        this.tltmAdd.setText(StringConstants.PA_BTN_TIP_ADD);
        this.tltmAdd.setImage(ImageConstants.IMG_16_ADD);
        this.tltmEdit = new ToolItem(toolBar, 0);
        this.tltmEdit.setText(StringConstants.PA_BTN_TIP_EDIT);
        this.tltmEdit.setImage(ImageConstants.IMG_16_EDIT);
        this.tltmEdit.setDisabledImage(ImageConstants.IMG_16_EDIT_DISABLED);
        this.tltmRemove = new ToolItem(toolBar, 0);
        this.tltmRemove.setText(StringConstants.PA_BTN_TIP_REMOVE);
        this.tltmRemove.setImage(ImageConstants.IMG_16_REMOVE);
        this.tltmRemove.setDisabledImage(ImageConstants.IMG_16_REMOVE_DISABLED);
        this.tltmClear = new ToolItem(toolBar, 0);
        this.tltmClear.setText(StringConstants.PA_BTN_TIP_CLEAR);
        this.tltmClear.setImage(ImageConstants.IMG_16_CLEAR);
        this.tltmMoveUp = new ToolItem(toolBar, 0);
        this.tltmMoveUp.setText(StringConstants.PA_BTN_TIP_UP);
        this.tltmMoveUp.setImage(ImageConstants.IMG_16_MOVE_UP);
        this.tltmMoveDown = new ToolItem(toolBar, 0);
        this.tltmMoveDown.setText(StringConstants.PA_BTN_TIP_DOWN);
        this.tltmMoveDown.setImage(ImageConstants.IMG_16_MOVE_DOWN);
        Composite compositeTable = new Composite(this.composite, 0);
        GridLayout gl_compositeTable = new GridLayout(1, false);
        gl_compositeTable.marginWidth = 0;
        gl_compositeTable.marginHeight = 0;
        compositeTable.setLayout((Layout)gl_compositeTable);
        compositeTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        compositeTable.setBounds(0, 0, 64, 64);
        this.tableViewer = new TableViewer(compositeTable, 67586);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GlobalVariablePart.this.enableDisableBtns();
            }
        });
        this.table = this.tableViewer.getTable();
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(ControlUtils.shouldLineVisble((Display)this.table.getDisplay()));
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        Menu popupMenu = new Menu((Control)this.table);
        MenuItem showPreferenceMenuItem = new MenuItem(popupMenu, 64);
        showPreferenceMenuItem.setText(StringConstants.PA_MENU_CONTEXT_SHOW_PREFERENCES);
        showPreferenceMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
                if (selection == null || selection.getFirstElement() == null) {
                    return;
                }
                GlobalVariablePart.this.eventBroker.post("GLOBAL_VARIABLE/SHOW_REFERENCES", selection.getFirstElement());
            }
        });
        this.table.setMenu(popupMenu);
        TableViewerColumn tableViewerColumnName = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnName = tableViewerColumnName.getColumn();
        tblclmnName.setWidth(200);
        tblclmnName.setText(StringConstants.PA_COL_NAME);
        tableViewerColumnName.setEditingSupport((EditingSupport)new GlobalVariableEdittingSupport(this));
        tableViewerColumnName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getName();
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnValue = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnValue = tableViewerColumnValue.getColumn();
        tblclmnValue.setWidth(350);
        tblclmnValue.setText(StringConstants.PA_COL_VALUE);
        tableViewerColumnValue.setEditingSupport((EditingSupport)new GlobalVariableEdittingSupport(this));
        tableViewerColumnValue.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getInitValue();
                }
                return "";
            }
        });
        TableViewerColumn tableViewerColumnDescription = new TableViewerColumn(this.tableViewer, 0);
        TableColumn tblclmnDescription = tableViewerColumnDescription.getColumn();
        tblclmnDescription.setWidth(250);
        tblclmnDescription.setText(StringConstants.PA_COL_DESCRIPTION);
        tableViewerColumnDescription.setEditingSupport((EditingSupport)new GlobalVariableEdittingSupport(this));
        tableViewerColumnDescription.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element != null && element instanceof GlobalVariableEntity) {
                    return ((GlobalVariableEntity)element).getDescription();
                }
                return "";
            }
        });
        ColumnViewerUtil.setTableActivation((TableViewer)this.tableViewer);
        this.setInput();
        this.registerControlModifyListeners();
    }

    private void addNewVariable(GlobalVariableEntity variableEntity) {
        this.executeOperation((IUndoableOperation)new AddNewVariableOperation(variableEntity));
        Trackings.trackCreatingObject((String)"profileVariable");
    }

    private void deleteSelectedVariables() {
        this.executeOperation((IUndoableOperation)new DeleteVariablesOperation());
    }

    private void clearVariables() {
        this.executeOperation((IUndoableOperation)new ClearVariableOperation());
    }

    private void editVariable() {
        this.executeOperation((IUndoableOperation)new EditVariableOperation());
    }

    private void moveUpVariable() {
        this.executeOperation((IUndoableOperation)new MoveUpVariableOperation());
    }

    private void moveDownVariable() {
        this.executeOperation((IUndoableOperation)new MoveDownVariableOperation());
    }

    private void registerControlModifyListeners() {
        this.tltmAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariableBuilderDialog dialog = new GlobalVariableBuilderDialog(GlobalVariablePart.this.composite.getShell(), null, GlobalVariablePart.this.getAllGlobalVariableName());
                if (dialog.open() == 0) {
                    GlobalVariablePart.this.addNewVariable(dialog.getVariableEntity());
                }
            }
        });
        this.tltmEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.editVariable();
            }
        });
        this.tltmRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.deleteSelectedVariables();
            }
        });
        this.tltmClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.clearVariables();
            }
        });
        this.tltmMoveUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.moveUpVariable();
            }
        });
        this.tltmMoveDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GlobalVariablePart.this.moveDownVariable();
            }
        });
    }

    private void setInput() {
        try {
            this.setInput(this.executionProfileEntity.getGlobalVariableEntities());
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    private void setInput(List<GlobalVariableEntity> newInput) {
        this.globalVariables.clear();
        this.globalVariables.addAll(newInput);
        this.tableViewer.setInput(this.globalVariables);
        this.refresh();
    }

    protected void refresh() {
        this.tableViewer.refresh();
        this.enableDisableBtns();
    }

    private void registerEventListeners() {
        this.eventBroker.subscribe("GLOBAL_VARIABLE/REFRESH", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/RENAMED", (EventHandler)this);
        this.eventBroker.subscribe("EXECUTION_PROFILE/DELETED", (EventHandler)this);
    }

    public void handleEvent(Event event) {
        switch (event.getTopic()) {
            case "GLOBAL_VARIABLE/REFRESH": {
                this.setInput();
                this.clearUndoRedoHistory();
                this.needToUpdateVariables.clear();
                break;
            }
            case "EXECUTION_PROFILE/RENAMED": {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof Object)) {
                    return;
                }
                ExecutionProfileEntity renamedProfile = (ExecutionProfileEntity)object;
                if (!this.executionProfileEntity.equals((Object)renamedProfile)) break;
                this.executionProfileEntity = renamedProfile;
                this.updateMPart();
                break;
            }
            case "EXECUTION_PROFILE/DELETED": {
                Object object = event.getProperty("org.eclipse.e4.data");
                if (!(object instanceof ExecutionProfileEntity)) {
                    return;
                }
                ExecutionProfileEntity deletedProfile = (ExecutionProfileEntity)object;
                if (!this.executionProfileEntity.equals((Object)deletedProfile)) break;
                this.dispose();
            }
        }
    }

    private void clearUndoRedoHistory() {
        this.operationExecutor.dispose();
        this.operationExecutor = new OperationExecutor((Object)this);
    }

    public void setDirty(boolean isDirty) {
        this.parentExecutionProfileCompositePart.setDirty(isDirty);
    }

    private void updateMPart() {
        this.mpart.setLabel(this.executionProfileEntity.getName());
        this.mpart.setElementId(EntityPartUtil.getExecutionProfilePartId((String)this.executionProfileEntity.getIdForDisplay()));
    }

    public void updateProfileEntityFrom(ExecutionProfileEntity entity) {
        ExecutionProfileEntity oldExecutionProfileEntity = this.executionProfileEntity;
        if (entity != null) {
            this.executionProfileEntity = entity;
            this.executionProfileEntity.setName(oldExecutionProfileEntity.getName());
            this.executionProfileEntity.setProject(oldExecutionProfileEntity.getProject());
            this.executionProfileEntity.setParentFolder(oldExecutionProfileEntity.getParentFolder());
            this.setInput();
        }
    }

    @Persist
    public void save() {
    }

    public void updateProfilEntityWithCurrentVariables() {
        this.executionProfileEntity.setGlobalVariableEntities(this.globalVariables);
    }

    public void updateVariableReferences() {
        if (this.needToUpdateVariableReferences()) {
            ProjectEntity currentProject = ProjectController.getInstance().getCurrentProject();
            try {
                for (Map.Entry<GlobalVariableEntity, String> needToUpdateVariable : this.needToUpdateVariables.entrySet()) {
                    String globalVariablePrefix = "GlobalVariable.";
                    String oldValue = String.valueOf(globalVariablePrefix) + needToUpdateVariable.getValue();
                    String newValue = String.valueOf(globalVariablePrefix) + needToUpdateVariable.getKey().getName();
                    GroovyRefreshUtil.updateScriptReferencesInTestCaseAndCustomScripts((String)oldValue, (String)newValue, (ProjectEntity)currentProject);
                }
                this.needToUpdateVariables.clear();
            }
            catch (IOException | CoreException throwable) {
                MessageDialog.openWarning(null, (String)StringConstants.ERROR_TITLE, (String)StringConstants.PA_ERROR_MSG_UNABLE_TO_UPDATE_VAR_REFERENCES);
            }
        }
    }

    private void enableDisableBtns() {
        StructuredSelection selection = (StructuredSelection)this.tableViewer.getSelection();
        boolean isEnabled = selection != null && selection.getFirstElement() != null;
        this.tltmEdit.setEnabled(isEnabled);
        this.tltmRemove.setEnabled(isEnabled);
    }

    private List<String> getAllGlobalVariableName() {
        ArrayList<String> varNames = new ArrayList<String>();
        if (this.tableViewer == null || this.tableViewer.getTable().isDisposed()) {
            return varNames;
        }
        TableItem[] tableItemArray = this.tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            varNames.add(((GlobalVariableEntity)item.getData()).getName());
            ++n2;
        }
        return varNames;
    }

    @PreDestroy
    public void dispose() {
        super.dispose();
        this.partService.hidePart(this.mpart);
        this.eventBroker.unsubscribe((EventHandler)this);
    }

    public boolean needToUpdateVariableReferences() {
        return !this.needToUpdateVariables.isEmpty();
    }

    public List<MPart> getChildParts() {
        ArrayList<MPart> res = new ArrayList<MPart>();
        res.add(this.getMPart());
        return res;
    }

    @Override
    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    @Override
    public void markDirty() {
        this.setDirty(true);
    }

    @Override
    public Map<GlobalVariableEntity, String> getNeedToUpdateVariables() {
        return this.needToUpdateVariables;
    }

    @Override
    public void performOperation(AbstractOperation operation) {
        this.executeOperation((IUndoableOperation)operation);
    }

    public ExecutionProfileEntity getEntity() {
        return this.executionProfileEntity;
    }

    public MPart getMPart() {
        return this.mpart;
    }

    public List<GlobalVariableEntity> getGlobalVariables() {
        return this.globalVariables;
    }

    public void setVariablesFromScriptContent(String scriptContent) throws Exception {
        ExecutionProfileEntity newVariableEntityWrapper = this.getVariableEntityWrapperFromScriptContent(scriptContent);
        if (newVariableEntityWrapper != null) {
            this.globalVariables.clear();
            this.globalVariables.addAll(newVariableEntityWrapper.getGlobalVariableEntities());
        } else {
            this.globalVariables.clear();
            this.globalVariables.addAll(new ArrayList());
        }
        this.tableViewer.setInput(this.globalVariables);
        this.refresh();
    }

    public ExecutionProfileEntity getVariableEntityWrapperFromScriptContent(String scriptContent) throws Exception {
        ExecutionProfileEntity newVariableEntityWrapper = null;
        if (scriptContent != null && scriptContent != "") {
            newVariableEntityWrapper = GlobalVariableController.getInstance().toExecutionProfileEntity(scriptContent);
        }
        return newVariableEntityWrapper;
    }

    public ExecutionProfileEntity getExecutionProfileEntity() {
        this.updateProfilEntityWithCurrentVariables();
        return this.executionProfileEntity;
    }

    public boolean isDirty() {
        return this.mpart.isDirty();
    }

    private class AddNewVariableOperation
    extends AbstractOperation {
        private GlobalVariableEntity variable;

        public AddNewVariableOperation(GlobalVariableEntity variable) {
            super(AddNewVariableOperation.class.getName());
            this.variable = variable;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.variable == null) {
                return Status.CANCEL_STATUS;
            }
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.add(this.variable);
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)this.variable));
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.remove(this.variable);
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class ClearVariableOperation
    extends AbstractOperation {
        private List<GlobalVariableEntity> oldInput;

        public ClearVariableOperation() {
            super(ClearVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (GlobalVariablePart.this.globalVariables.isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            this.oldInput = new ArrayList<GlobalVariableEntity>(GlobalVariablePart.this.globalVariables);
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.clear();
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.setInput(this.oldInput);
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class DeleteVariablesOperation
    extends AbstractOperation {
        private Map<GlobalVariableEntity, Integer> deletedVariables;

        public DeleteVariablesOperation() {
            super(DeleteVariablesOperation.class.getName());
            this.deletedVariables = new LinkedHashMap<GlobalVariableEntity, Integer>();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GlobalVariableEntity selectedVariable;
                int index;
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof GlobalVariableEntity && (index = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem)) != -1) {
                    this.deletedVariables.put(selectedVariable, index);
                }
                ++n2;
            }
            GlobalVariablePart.this.globalVariables.removeAll(selection.toList());
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.globalVariables.removeAll(this.deletedVariables.keySet());
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            for (Map.Entry<GlobalVariableEntity, Integer> deletedVariable : this.deletedVariables.entrySet()) {
                GlobalVariablePart.this.globalVariables.add(deletedVariable.getValue(), deletedVariable.getKey());
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection(this.deletedVariables.keySet().toArray()));
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class EditVariableOperation
    extends AbstractOperation {
        private GlobalVariableEntity oldVariable;
        private GlobalVariableEntity variable;
        private GlobalVariableEntity newVariable;
        private boolean isNameChanged;

        public EditVariableOperation() {
            super(EditVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            boolean isChanged;
            if (GlobalVariablePart.this.tableViewer.getSelection().isEmpty()) {
                return Status.CANCEL_STATUS;
            }
            Object firstElement = ((StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection()).getFirstElement();
            if (firstElement == null || !(firstElement instanceof GlobalVariableEntity)) {
                return Status.CANCEL_STATUS;
            }
            this.variable = (GlobalVariableEntity)firstElement;
            Point centerLocation = null;
            GlobalVariableBuilderDialog dialog = new GlobalVariableBuilderDialog(GlobalVariablePart.this.composite.getShell(), this.variable, centerLocation, GlobalVariablePart.this.getAllGlobalVariableName());
            if (dialog.open() != 0) {
                return Status.CANCEL_STATUS;
            }
            this.newVariable = dialog.getVariableEntity();
            boolean bl = isChanged = !this.variable.getDescription().equals(this.newVariable.getDescription()) || !this.variable.getInitValue().equals(this.newVariable.getInitValue()) || !this.variable.getName().equals(this.newVariable.getName());
            if (!isChanged) {
                return Status.CANCEL_STATUS;
            }
            this.oldVariable = this.variable.clone();
            this.isNameChanged = !this.variable.getName().equals(this.newVariable.getName());
            return this.redo(monitor, info);
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.isNameChanged) {
                GlobalVariablePart.this.needToUpdateVariables.put(this.variable, this.oldVariable.getName());
            }
            this.doEditVariable(this.newVariable);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.isNameChanged) {
                if (GlobalVariablePart.this.needToUpdateVariables.containsKey(this.variable)) {
                    GlobalVariablePart.this.needToUpdateVariables.remove(this.variable);
                } else {
                    GlobalVariablePart.this.needToUpdateVariables.put(this.variable, this.newVariable.getName());
                }
            }
            this.doEditVariable(this.oldVariable);
            return Status.OK_STATUS;
        }

        private void doEditVariable(GlobalVariableEntity changedVariable) {
            this.variable.setDescription(changedVariable.getDescription());
            this.variable.setInitValue(changedVariable.getInitValue());
            this.variable.setName(changedVariable.getName());
            GlobalVariablePart.this.tableViewer.refresh((Object)this.variable);
            GlobalVariablePart.this.setDirty(true);
        }
    }

    private class MoveDownVariableOperation
    extends AbstractOperation {
        private Integer moveDownVariable;

        public MoveDownVariableOperation() {
            super(MoveDownVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            List selections = selection.toList();
            Collections.reverse(selections);
            for (Object selectedItem : selections) {
                GlobalVariableEntity selectedVariable;
                int indexMove;
                if (!(selectedItem instanceof GlobalVariableEntity) || (indexMove = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem) + 1) >= GlobalVariablePart.this.globalVariables.size()) continue;
                GlobalVariableEntity variableAfter = GlobalVariablePart.this.globalVariables.get(indexMove);
                if (!variableAfter.equals(selectedVariable)) {
                    Collections.swap(GlobalVariablePart.this.globalVariables, indexMove - 1, indexMove);
                }
                this.moveDownVariable = indexMove;
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(indexMove)));
                break;
            }
            if (this.moveDownVariable == null) {
                return Status.CANCEL_STATUS;
            }
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.moveDownVariable != null) {
                Collections.swap(GlobalVariablePart.this.globalVariables, this.moveDownVariable - 1, (int)this.moveDownVariable);
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(this.moveDownVariable - 1)));
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }

    private class MoveUpVariableOperation
    extends AbstractOperation {
        private Integer moveUpVariable;

        public MoveUpVariableOperation() {
            super(MoveUpVariableOperation.class.getName());
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            StructuredSelection selection = (StructuredSelection)GlobalVariablePart.this.tableViewer.getSelection();
            if (selection.size() <= 0) {
                return Status.CANCEL_STATUS;
            }
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                GlobalVariableEntity selectedVariable;
                int indexMove;
                Object selectedItem = objectArray[n2];
                if (selectedItem instanceof GlobalVariableEntity && (indexMove = GlobalVariablePart.this.globalVariables.indexOf(selectedVariable = (GlobalVariableEntity)selectedItem) - 1) >= 0) {
                    GlobalVariableEntity variableBefore = GlobalVariablePart.this.globalVariables.get(indexMove);
                    if (!variableBefore.equals(selectedVariable)) {
                        Collections.swap(GlobalVariablePart.this.globalVariables, indexMove, indexMove + 1);
                    }
                    this.moveUpVariable = indexMove;
                    GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(indexMove)));
                    break;
                }
                ++n2;
            }
            if (this.moveUpVariable == null) {
                return Status.CANCEL_STATUS;
            }
            GlobalVariablePart.this.refresh();
            if (OSUtil.isMacBigSurOrLater()) {
                GlobalVariablePart.this.getTableViewer().getTable().redraw();
            }
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            if (this.moveUpVariable != null) {
                Collections.swap(GlobalVariablePart.this.globalVariables, this.moveUpVariable + 1, (int)this.moveUpVariable);
                GlobalVariablePart.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)GlobalVariablePart.this.globalVariables.get(this.moveUpVariable + 1)));
            }
            GlobalVariablePart.this.refresh();
            GlobalVariablePart.this.setDirty(true);
            return Status.OK_STATUS;
        }
    }
}

