/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.google.gson.Gson;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.handlers.UpdateChromeWebdriverHandler;
import com.kms.katalon.composer.handlers.UpdateEdgeChromiumWebdriverHandler;
import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.driver.DriverType;
import com.kms.katalon.core.network.ProxyInformation;
import com.kms.katalon.core.network.ProxyOption;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.util.internal.ZipUtil;
import com.kms.katalon.core.webui.driver.DriverFactory;
import com.kms.katalon.core.webui.driver.WebUIDriverType;
import com.kms.katalon.core.webui.util.WebDriverPropertyUtil;
import com.kms.katalon.core.webui.util.WebDriverProxyUtil;
import com.kms.katalon.execution.configuration.IDriverConnector;
import com.kms.katalon.execution.configuration.IExecutionSetting;
import com.kms.katalon.execution.configuration.impl.DefaultExecutionSetting;
import com.kms.katalon.execution.util.ExecutionUtil;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.core.HTMLElementCaptureServer;
import com.kms.katalon.objectspy.exception.BrowserNotSupportedException;
import com.kms.katalon.objectspy.exception.ExtensionNotFoundException;
import com.kms.katalon.objectspy.preferences.ObjectSpyPreferences;
import com.kms.katalon.objectspy.util.FileUtil;
import com.kms.katalon.objectspy.websocket.AddonHotKeyData;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.AddonSocketServer;
import com.kms.katalon.objectspy.websocket.messages.StartInspectAddonMessage;
import com.kms.katalon.selenium.driver.CFirefoxDriver;
import com.kms.katalon.tracking.service.Trackings;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.InvalidPathException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.UnreachableBrowserException;
import org.osgi.framework.FrameworkUtil;

public class InspectSession
implements Runnable {
    private static final String HTTP = "http";
    private static final String ABOUT_BLANK = "about:blank";
    public static final String OBJECT_SPY_ADD_ON_NAME = "Object Spy";
    protected static final String LOAD_EXTENSION_CHROME_PREFIX = "load-extension=";
    protected static final String LOAD_EXTENSION_EDGE_CHROMIUM_PREFIX = "load-extension=";
    private static final String VARIABLE_INIT_EXPRESSION_FOR_CHROME = "katalonServerPort = ''{0}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {1};\r\nspy_loadDomMapHotKey = {2};\r\n";
    private static final String VARIABLE_INIT_EXPRESSION_FOR_EDGE_CHROMIUM = "katalonServerPort = ''{0}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {1};\r\nspy_loadDomMapHotKey = {2};\r\n";
    private static final String VARIABLE_INIT_FILE_FOR_CHROME = "chrome_variables_init.js";
    private static final String VARIABLE_INIT_FILE_FOR_EDGE_CHROMIUM = "edge_chromium_variables_init.js";
    private static final String SERVER_URL_FILE_NAME = "serverUrl.txt";
    private static final String OBJECT_SPY_APPLICATION_DATA_FOLDER = String.valueOf(System.getProperty("user.home")) + File.separator + "AppData" + File.separator + "Local" + File.separator + "KMS" + File.separator + "qAutomate" + File.separator + "ObjectSpy";
    protected static final String IE_ADDON_BHO_KEY = "{8CB0FB3A-8EFA-4F94-B605-F3427688F8C7}";
    protected static final String IE_ABSOLUTE_PATH = "C:\\Program Files\\Internet Explorer\\iexplore.exe";
    protected static final String IE_32BIT_ABSOLUTE_PATH = "C:\\Program Files (x86)\\Internet Explorer\\iexplore.exe";
    protected static final String CHROME_RECORD_SPY_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Chrome" + File.separator + "Object Spy" + File.separator + "KR";
    protected static final String EDGE_CHROMIUM_RECORD_SPY_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Edge Chromium" + File.separator + "Object Spy" + File.separator + "KR";
    protected static final String FIREFOX_RECORD_SPY_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "objectspy.xpi";
    protected static final String FIREFOX_RECORD_SMART_WAIT_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "smartwait.xpi";
    protected static final String FIREFOX_RECORD_SPY_FOLDER_RELATIVE_PATH = String.valueOf(File.separator) + "Firefox" + File.separator + "objectspy";
    protected static final String CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Chrome" + File.separator + "Smart Wait";
    protected static final String EDGE_CHROMIUM_SMART_WAIT_EXTENSION_RELATIVE_PATH = String.valueOf(File.separator) + "Edge Chromium" + File.separator + "Smart Wait";
    private static final String CAP_IE_USE_PER_PROCESS_PROXY = "ie.usePerProcessProxy";
    private static final String CHROME_PROPERTY_USER_DATA_DIR = "user-data-dir=";
    private static final String CHROME_PROPERTY_PROFILE_DIR = "profile-directory=";
    protected String projectDir;
    protected boolean isRunFlag;
    protected WebDriver driver;
    protected Object options;
    protected WebUIDriverType webUiDriverType;
    protected HTMLElementCaptureServer server;
    private String startUrl;
    private boolean driverStarted = false;
    private IDriverConnector driverConnector;
    private String chromeProfile;
    private Shell recorderDialogShell;

    public InspectSession(HTMLElementCaptureServer server, IDriverConnector driverConnector, String startUrl, String chromeProfile, Shell recorderDialogShell) {
        this.server = server;
        this.driverConnector = driverConnector;
        this.webUiDriverType = (WebUIDriverType)driverConnector.getDriverType();
        this.startUrl = startUrl;
        this.isRunFlag = true;
        this.chromeProfile = chromeProfile;
        this.recorderDialogShell = recorderDialogShell;
    }

    public InspectSession(HTMLElementCaptureServer server, IDriverConnector driverConnector) {
        this(server, driverConnector, null, null, null);
    }

    protected void setUp() throws IOException, ExtensionNotFoundException, BrowserNotSupportedException {
        DefaultExecutionSetting executionSetting = new DefaultExecutionSetting();
        executionSetting.setTimeout(ExecutionUtil.getDefaultImplicitTimeout());
        HashMap<String, IDriverConnector> driverConnectors = new HashMap<String, IDriverConnector>(1);
        driverConnectors.put("WebUI", this.driverConnector);
        RunConfiguration.setExecutionSetting((Map)ExecutionUtil.getExecutionProperties((IExecutionSetting)executionSetting, driverConnectors, null));
        this.options = this.createDriverOptions(this.webUiDriverType);
        if (this.webUiDriverType == WebUIDriverType.IE_DRIVER) {
            this.setupIE();
        }
    }

    @Override
    public void run() {
        try {
            this.setUp();
        }
        catch (BrowserNotSupportedException | ExtensionNotFoundException | IOException e) {
            LoggerSingleton.logError((Throwable)e);
            InspectSession.showErrorMessageDialog(e.getMessage());
        }
        this.runSeleniumWebDriver();
    }

    public void setupIE() throws IOException {
        File settingFolder = new File(this.getIEApplicationDataFolder());
        if (!settingFolder.exists()) {
            settingFolder.mkdirs();
        }
        File serverSettingFile = new File(this.getIEApplicationServerSettingFile());
        FileUtils.writeStringToFile((File)serverSettingFile, (String)this.server.getServerUrl());
    }

    protected String getIEApplicationServerSettingFile() {
        return String.valueOf(this.getIEApplicationDataFolder()) + File.separator + SERVER_URL_FILE_NAME;
    }

    protected String getIEApplicationDataFolder() {
        return OBJECT_SPY_APPLICATION_DATA_FOLDER;
    }

    /*
     * Loose catch block
     */
    protected void runSeleniumWebDriver() {
        block26: {
            try {
                try {
                    Thread.sleep(5L);
                    this.driver = DriverFactory.openWebDriver((DriverType)this.webUiDriverType, (Object)this.options);
                    this.driverStarted = true;
                    switch (this.webUiDriverType) {
                        case FIREFOX_DRIVER: {
                            LoggerSingleton.logInfo((String)MessageFormat.format("Installing Katalon Recorder for {0}...", DriverFactory.getBrowserVersion((WebDriver)this.driver)));
                            CFirefoxDriver firefoxDriver = (CFirefoxDriver)this.driver;
                            URL geckoDriverServiceUrl = firefoxDriver.getGeckoDriverService().getUrl();
                            CloseableHttpClient recordSpyInstallclient = HttpClientBuilder.create().build();
                            HttpPost httpRecordSpyInstallPost = new HttpPost(String.valueOf(geckoDriverServiceUrl.toString()) + "/session/" + ((RemoteWebDriver)this.driver).getSessionId() + "/moz/addon/install");
                            httpRecordSpyInstallPost.setHeader("Accept", "application/json");
                            httpRecordSpyInstallPost.setHeader("Content-type", "application/json");
                            String recordSpyInstallBodyContent = String.format("{\"path\": \"%s\"}", StringEscapeUtils.escapeJava((String)this.getFirefoxRecordSpyAddonFile().getAbsolutePath()));
                            httpRecordSpyInstallPost.setEntity((HttpEntity)new StringEntity(recordSpyInstallBodyContent));
                            recordSpyInstallclient.execute((HttpUriRequest)httpRecordSpyInstallPost);
                            if (this.shouldInstallSmartWait()) {
                                CloseableHttpClient smartWaitInstallclient = HttpClientBuilder.create().build();
                                HttpPost smartWaitHttpPost = new HttpPost(String.valueOf(geckoDriverServiceUrl.toString()) + "/session/" + ((RemoteWebDriver)this.driver).getSessionId() + "/moz/addon/install");
                                smartWaitHttpPost.setHeader("Accept", "application/json");
                                smartWaitHttpPost.setHeader("Content-type", "application/json");
                                String smartWaitBodyContent = String.format("{\"path\": \"%s\"}", StringEscapeUtils.escapeJava((String)this.getFirefoxSmartWaitAddonFile().getAbsolutePath()));
                                smartWaitHttpPost.setEntity((HttpEntity)new StringEntity(smartWaitBodyContent));
                                smartWaitInstallclient.execute((HttpUriRequest)smartWaitHttpPost);
                            }
                            this.handleForFirefoxAddon();
                            break;
                        }
                    }
                    if (StringUtils.isNotEmpty((String)this.startUrl)) {
                        try {
                            this.driver.navigate().to(PathUtil.getUrl((String)this.startUrl, (String)HTTP));
                        }
                        catch (MalformedURLException | URISyntaxException | InvalidPathException exception) {}
                    }
                    while (this.isRunFlag) {
                        try {
                            Thread.sleep(1000L);
                            if (this.driver == null) break;
                            if (this.driver.getTitle() == null) {
                                break;
                            }
                            this.driver.getWindowHandle();
                        }
                        catch (NoSuchWindowException noSuchWindowException) {
                            break;
                        }
                        catch (UnreachableBrowserException unreachableBrowserException) {
                            break;
                        }
                        catch (WebDriverException e) {
                            if (!e.getMessage().startsWith("chrome not reachable")) continue;
                            break;
                        }
                    }
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    InspectSession.showErrorMessageDialogOnTop(MessageFormat.format(ObjectspyMessageConstants.EXC_USER_DATA_DIR_IN_USE, this.webUiDriverType.toString()), this.recorderDialogShell);
                    this.dispose();
                }
                catch (WebDriverException e) {
                    if (this.failedDueToOutdatedChromeDriver(e.getMessage())) {
                        Trackings.trackFailedToSpyRecordDueToOutdatedChromeDriver();
                        this.updateChromeDriver();
                    } else if (this.failedDueToOutdatedEdgeChromiumDriver(e.getMessage())) {
                        Trackings.trackFailedToSpyRecordDueToOutdatedEdgeChromiumDriver();
                        this.updateEdgeChromiumDriver();
                    } else {
                        InspectSession.showErrorMessageDialog(e.getMessage());
                    }
                    this.dispose();
                }
                catch (Exception e) {
                    LoggerSingleton.logError((Throwable)e);
                    InspectSession.showErrorMessageDialog(e.getMessage());
                    this.dispose();
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                this.dispose();
            }
        }
    }

    private boolean failedDueToOutdatedEdgeChromiumDriver(String message) {
        return message.contains("This version of MSEdgeDriver only supports MSEdge version");
    }

    private boolean failedDueToOutdatedChromeDriver(String message) {
        return message.contains("This version of ChromeDriver only supports Chrome version");
    }

    private void updateChromeDriver() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean upgrade = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, (String)ObjectspyMessageConstants.DIA_MSG_DRIVER_OUTDATED_CHROME_DRIVER);
                if (upgrade) {
                    new UpdateChromeWebdriverHandler().execute(Display.getCurrent().getActiveShell());
                }
            }
        });
    }

    private void updateEdgeChromiumDriver() {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean upgrade = MessageDialog.openConfirm((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, (String)ObjectspyMessageConstants.DIA_MSG_DRIVER_OUTDATED_EDGE_CHROMIUM_DRIVER);
                if (upgrade) {
                    new UpdateEdgeChromiumWebdriverHandler().execute(Display.getCurrent().getActiveShell());
                }
            }
        });
    }

    protected void handleForFirefoxAddon() throws InterruptedException {
        LoggerSingleton.logInfo((String)"Connecting Firefox Recorder with socket server...");
        AddonSocketServer socketServer = AddonSocketServer.getInstance();
        while (socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString()) == null && this.isRunFlag) {
            Thread.sleep(500L);
        }
        AddonSocket firefoxAddonSocket = socketServer.getAddonSocketByBrowserName(this.webUiDriverType.toString());
        firefoxAddonSocket.sendMessage(new StartInspectAddonMessage());
        LoggerSingleton.logInfo((String)"Sending Inspect Session message to Firefox Recorder...");
    }

    public boolean isDriverStarted() {
        return this.driverStarted;
    }

    private static void showErrorMessageDialog(final String message) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)GlobalStringConstants.ERROR, (String)message);
            }
        });
    }

    private static void showErrorMessageDialogOnTop(final String message, final Shell recorderDialogShell) {
        UISynchronizeService.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.openError((Shell)recorderDialogShell, (String)GlobalStringConstants.ERROR, (String)message);
            }
        });
    }

    protected Object createDriverOptions(WebUIDriverType driverType) throws IOException, ExtensionNotFoundException, BrowserNotSupportedException {
        DesiredCapabilities capabilities = WebDriverPropertyUtil.toDesireCapabilities((Map)RunConfiguration.getDriverPreferencesProperties((String)"WebUI"), (WebUIDriverType)driverType);
        switch (driverType) {
            case CHROME_DRIVER: {
                return this.chromeProfile != null ? this.createChromeDriverOptionsWithProfile(capabilities) : this.createChromeDriverOptions(capabilities);
            }
            case IE_DRIVER: {
                return this.createIEDesiredCapabilities(capabilities);
            }
            case FIREFOX_DRIVER: {
                ProxyInformation proxyInfo = RunConfiguration.getProxyInformation();
                if (proxyInfo.isApplyToDesiredCapabilities()) {
                    capabilities.setCapability("proxy", InspectSession.getDefaultProxy());
                }
                return capabilities;
            }
            case EDGE_CHROMIUM_DRIVER: {
                return this.createEdgeChromiumDriverOptions(capabilities);
            }
        }
        return capabilities;
    }

    private DesiredCapabilities createIEDesiredCapabilities(DesiredCapabilities capabilities) {
        capabilities.setCapability("initialBrowserUrl", ABOUT_BLANK);
        capabilities.setCapability(CAP_IE_USE_PER_PROCESS_PROXY, "true");
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && !WebDriverProxyUtil.isNoProxy((ProxyInformation)proxyInformation)) {
            capabilities.setCapability("proxy", InspectSession.getDefaultProxy(this.startUrl, capabilities.getBrowserName()));
        }
        return capabilities;
    }

    protected FirefoxProfile createFireFoxProfile() throws IOException {
        FirefoxProfile firefoxProfile = WebDriverPropertyUtil.createDefaultFirefoxProfile();
        firefoxProfile.addExtension(this.getFirefoxRecordSpyAddonFile());
        if (this.shouldInstallSmartWait()) {
            firefoxProfile.addExtension(this.getFirefoxSmartWaitAddonFile());
        }
        return firefoxProfile;
    }

    protected DesiredCapabilities createChromeDriverOptions(DesiredCapabilities capabilities) throws IOException, ExtensionNotFoundException {
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks((ProxyInformation)proxyInformation)) {
                WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{"--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString((ProxyInformation)proxyInformation)});
            } else {
                capabilities.setCapability("proxy", InspectSession.getDefaultProxy());
            }
        }
        this.loadChromeExtensions(capabilities);
        return capabilities;
    }

    private void loadChromeExtensions(DesiredCapabilities capabilities) throws ExtensionNotFoundException, IOException {
        boolean isInstalledKatalonCompactUtility = WebDriverPropertyUtil.didUserProfileInstallKatalonCompactUtility((WebUIDriverType)WebUIDriverType.CHROME_DRIVER, (DesiredCapabilities)capabilities);
        if (isInstalledKatalonCompactUtility) {
            return;
        }
        File chromeRecordSpyExtensionFolder = this.getRecordSpyExtensionFile();
        if (chromeRecordSpyExtensionFolder == null || !chromeRecordSpyExtensionFolder.isDirectory() || !chromeRecordSpyExtensionFolder.exists()) {
            throw new ExtensionNotFoundException(this.getChromeRecordSpyExtensionPath(), WebUIDriverType.CHROME_DRIVER);
        }
        File chromeSmartWaitExtensionFolder = this.getSmartWaitExtensionFile();
        if (chromeSmartWaitExtensionFolder == null || !chromeSmartWaitExtensionFolder.isDirectory() || !chromeSmartWaitExtensionFolder.exists()) {
            throw new ExtensionNotFoundException(this.getChromeSmartWaitExtensionPath(), WebUIDriverType.CHROME_DRIVER);
        }
        this.generateVariableInitFileForChrome(chromeRecordSpyExtensionFolder);
        WebDriverPropertyUtil.removeArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{"--disable-extensions"});
        String extensions = "";
        extensions = this.shouldInstallSmartWait() ? "load-extension=" + chromeRecordSpyExtensionFolder.getCanonicalPath() + "," + chromeSmartWaitExtensionFolder.getCanonicalPath() : "load-extension=" + chromeRecordSpyExtensionFolder.getCanonicalPath();
        WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{extensions});
    }

    protected DesiredCapabilities createChromeDriverOptionsWithProfile(DesiredCapabilities capabilities) {
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks((ProxyInformation)proxyInformation)) {
                WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{"--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString((ProxyInformation)proxyInformation)});
            } else {
                capabilities.setCapability("proxy", InspectSession.getDefaultProxy());
            }
        }
        WebDriverPropertyUtil.removeArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{"--disable-extensions"});
        File file = new File(this.chromeProfile);
        String name = file.getName();
        String dir = file.getParent();
        String userDataDir = CHROME_PROPERTY_USER_DATA_DIR + dir;
        String profile = CHROME_PROPERTY_PROFILE_DIR + name;
        WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{userDataDir});
        WebDriverPropertyUtil.addArgumentsForChrome((DesiredCapabilities)capabilities, (String[])new String[]{profile});
        return capabilities;
    }

    protected DesiredCapabilities createEdgeChromiumDriverOptions(DesiredCapabilities capabilities) throws IOException, ExtensionNotFoundException {
        boolean isInstalledKatalonCompactUtility;
        ProxyInformation proxyInformation = RunConfiguration.getProxyInformation();
        if (proxyInformation.isApplyToDesiredCapabilities() && ProxyOption.valueOf((String)proxyInformation.getProxyOption()) == ProxyOption.MANUAL_CONFIG) {
            if (WebDriverProxyUtil.isManualSocks((ProxyInformation)proxyInformation)) {
                WebDriverPropertyUtil.addArgumentsForEdgeChromium((DesiredCapabilities)capabilities, (String[])new String[]{"--proxy-server=socks5://" + WebDriverProxyUtil.getProxyString((ProxyInformation)proxyInformation)});
            } else {
                capabilities.setCapability("proxy", InspectSession.getDefaultProxy());
            }
        }
        if (isInstalledKatalonCompactUtility = WebDriverPropertyUtil.didUserProfileInstallKatalonCompactUtility((WebUIDriverType)WebUIDriverType.EDGE_CHROMIUM_DRIVER, (DesiredCapabilities)capabilities)) {
            return capabilities;
        }
        File edgeChromiumRecordSpyExtensionFolder = this.getEdgeChromiumRecordSpyExtensionFile();
        if (edgeChromiumRecordSpyExtensionFolder == null || !edgeChromiumRecordSpyExtensionFolder.isDirectory() || !edgeChromiumRecordSpyExtensionFolder.exists()) {
            throw new ExtensionNotFoundException(this.getChromeRecordSpyExtensionPath(), WebUIDriverType.EDGE_CHROMIUM_DRIVER);
        }
        File edgeChromiumSmartWaitExtensionFolder = this.getEdgeChromiumSmartWaitExtensionFile();
        if (edgeChromiumSmartWaitExtensionFolder == null || !edgeChromiumSmartWaitExtensionFolder.isDirectory() || !edgeChromiumSmartWaitExtensionFolder.exists()) {
            throw new ExtensionNotFoundException(this.getChromeSmartWaitExtensionPath(), WebUIDriverType.EDGE_CHROMIUM_DRIVER);
        }
        this.generateVariableInitFileForEdgeChromium(edgeChromiumRecordSpyExtensionFolder);
        WebDriverPropertyUtil.removeArgumentsForEdgeChromium((DesiredCapabilities)capabilities, (String[])new String[]{"--disable-extensions"});
        String extensions = "";
        extensions = this.shouldInstallSmartWait() ? "load-extension=" + edgeChromiumRecordSpyExtensionFolder.getCanonicalPath() + "," + edgeChromiumSmartWaitExtensionFolder.getCanonicalPath() : "load-extension=" + edgeChromiumRecordSpyExtensionFolder.getCanonicalPath();
        WebDriverPropertyUtil.addArgumentsForEdgeChromium((DesiredCapabilities)capabilities, (String[])new String[]{extensions});
        return capabilities;
    }

    private static Map<String, Object> getDefaultProxy() {
        return WebDriverProxyUtil.getSeleniumProxy((ProxyInformation)RunConfiguration.getProxyInformation());
    }

    private static Map<String, Object> getDefaultProxy(String url, String driverType) {
        return WebDriverProxyUtil.getSeleniumProxy((ProxyInformation)RunConfiguration.getProxyInformation(), (String)url, (String)driverType);
    }

    private void generateVariableInitFileForChrome(File chromeExtensionFolder) throws IOException {
        File variableInitJSFile = new File(String.valueOf(chromeExtensionFolder.getAbsolutePath()) + File.separator + VARIABLE_INIT_FILE_FOR_CHROME);
        AddonHotKeyData captureObjectHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getCaptureObjectHotKey());
        AddonHotKeyData loadDomMapHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getLoadDomMapHotKey());
        Gson gson = new Gson();
        FileUtils.writeStringToFile((File)variableInitJSFile, (String)MessageFormat.format("katalonServerPort = ''{0}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {1};\r\nspy_loadDomMapHotKey = {2};\r\n", String.valueOf(this.server.getServerPort()), gson.toJson((Object)captureObjectHotKey), gson.toJson((Object)loadDomMapHotKey)), (Charset)Charset.defaultCharset());
    }

    private void generateVariableInitFileForEdgeChromium(File edgeChromiumExtensionFolder) throws IOException {
        File variableInitJSFile = new File(String.valueOf(edgeChromiumExtensionFolder.getAbsolutePath()) + File.separator + VARIABLE_INIT_FILE_FOR_EDGE_CHROMIUM);
        AddonHotKeyData captureObjectHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getCaptureObjectHotKey());
        AddonHotKeyData loadDomMapHotKey = AddonHotKeyData.buildFrom(ObjectSpyPreferences.getLoadDomMapHotKey());
        Gson gson = new Gson();
        FileUtils.writeStringToFile((File)variableInitJSFile, (String)MessageFormat.format("katalonServerPort = ''{0}''\r\nkatalonOnOffStatus = true\r\nspy_captureObjectHotKey = {1};\r\nspy_loadDomMapHotKey = {2};\r\n", String.valueOf(this.server.getServerPort()), gson.toJson((Object)captureObjectHotKey), gson.toJson((Object)loadDomMapHotKey)), (Charset)Charset.defaultCharset());
    }

    protected File getRecordSpyExtensionFile() throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getChromeRecordSpyExtensionPath());
        }
        return chromeExtension;
    }

    protected File getSmartWaitExtensionFile() throws IOException {
        File chromeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            chromeExtension = new File(String.valueOf(extensionFolder.getAbsolutePath()) + CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH);
        }
        return chromeExtension;
    }

    protected File getEdgeChromiumRecordSpyExtensionFile() throws IOException {
        File EdgeChromium = null;
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            EdgeChromium = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getEdgeChromiumRecordSpyExtensionPath());
        }
        return EdgeChromium;
    }

    protected File getEdgeChromiumSmartWaitExtensionFile() throws IOException {
        File edgeExtension = null;
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            edgeExtension = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getEdgeChromiumSmartWaitExtensionPath());
        }
        return edgeExtension;
    }

    protected File getFirefoxAddonExtractedFolder() throws IOException {
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            File firefoxExtensionFolder = FileUtil.getExtensionBuildFolder();
            File firefoxAddonExtracted = new File(firefoxExtensionFolder, FIREFOX_RECORD_SPY_FOLDER_RELATIVE_PATH);
            if (firefoxAddonExtracted.exists()) {
                FileUtils.cleanDirectory((File)firefoxAddonExtracted);
            }
            File firefoxAddon = new File(String.valueOf(extensionFolder.getAbsolutePath()) + this.getFirefoxExtensionPath());
            ZipUtil.extract((File)firefoxAddon, (File)firefoxAddonExtracted);
            return firefoxAddonExtracted;
        }
        return null;
    }

    protected File getFirefoxRecordSpyAddonFile() throws IOException {
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            return new File(extensionFolder.getAbsolutePath(), FIREFOX_RECORD_SPY_EXTENSION_RELATIVE_PATH);
        }
        return null;
    }

    protected File getFirefoxSmartWaitAddonFile() throws IOException {
        File extensionFolder = FileUtil.getExtensionsDirectory(FrameworkUtil.getBundle(InspectSession.class));
        if (extensionFolder.exists() && extensionFolder.isDirectory()) {
            return new File(extensionFolder.getAbsolutePath(), FIREFOX_RECORD_SMART_WAIT_RELATIVE_PATH);
        }
        return null;
    }

    public void stop() {
        this.isRunFlag = false;
        this.dispose();
    }

    protected void dispose() {
        try {
            File serverSettingFile;
            if (this.driver != null && ((RemoteWebDriver)this.driver).getSessionId() != null) {
                this.driver.quit();
            }
            if ((serverSettingFile = new File(this.getIEApplicationServerSettingFile())).exists()) {
                serverSettingFile.delete();
            }
        }
        catch (UnreachableBrowserException unreachableBrowserException) {
        }
        catch (WebDriverException e) {
            LoggerSingleton.logError((Throwable)e);
        }
    }

    public boolean isRunning() {
        return this.isRunFlag;
    }

    protected String getAddOnName() {
        return OBJECT_SPY_ADD_ON_NAME;
    }

    protected String getChromeRecordSpyExtensionPath() {
        return CHROME_RECORD_SPY_EXTENSION_RELATIVE_PATH;
    }

    protected String getChromeSmartWaitExtensionPath() {
        return CHROME_SMART_WAIT_EXTENSION_RELATIVE_PATH;
    }

    protected String getEdgeChromiumRecordSpyExtensionPath() {
        return EDGE_CHROMIUM_RECORD_SPY_EXTENSION_RELATIVE_PATH;
    }

    protected String getEdgeChromiumSmartWaitExtensionPath() {
        return EDGE_CHROMIUM_SMART_WAIT_EXTENSION_RELATIVE_PATH;
    }

    protected String getFirefoxExtensionPath() {
        return FIREFOX_RECORD_SPY_EXTENSION_RELATIVE_PATH;
    }

    protected String getIEAddonRegistryKey() {
        return IE_ADDON_BHO_KEY;
    }

    public WebDriver getWebDriver() {
        return this.driver;
    }

    public WebUIDriverType getWebUiDriverType() {
        return this.webUiDriverType;
    }

    private boolean shouldInstallSmartWait() {
        boolean globalSmartWaitEnabled = Optional.ofNullable(RunConfiguration.getExecutionProperties().get("globalSmartWaitEnabled")).orElse(false);
        return globalSmartWaitEnabled;
    }
}

