/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.core;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.objectspy.core.ClientMessage;
import com.kms.katalon.objectspy.core.KatalonRequest;
import com.kms.katalon.objectspy.core.RequestFailedListener;
import com.kms.katalon.objectspy.highlight.HighlightRequest;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.Executors;
import org.eclipse.e4.core.services.log.Logger;

public class KatalonRequestHandler {
    private static KatalonRequestHandler instance;
    private KatalonRequest currentRequest;
    private RequestFailedListener requestFailedListener;
    private Logger logger = LoggerSingleton.getInstance().getLogger();
    private static int clientId;

    static {
        clientId = 0;
    }

    private KatalonRequestHandler() {
    }

    public static KatalonRequestHandler getInstance() {
        if (instance == null) {
            instance = new KatalonRequestHandler();
        }
        return instance;
    }

    public void setRequest(KatalonRequest request, RequestFailedListener listener) {
        this.requestFailedListener = listener;
        this.currentRequest = request;
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    try {
                        Thread.sleep(2000L);
                        KatalonRequestHandler.this.removeCurrentRequest();
                    }
                    catch (Exception ex) {
                        KatalonRequestHandler.this.logger.error((Throwable)ex);
                        KatalonRequestHandler.this.currentRequest = null;
                        KatalonRequestHandler.this.requestFailedListener = null;
                    }
                }
                finally {
                    KatalonRequestHandler.this.currentRequest = null;
                    KatalonRequestHandler.this.requestFailedListener = null;
                }
            }
        });
    }

    public void processIncomeRequest(ClientMessage clientMessage, OutputStream out) {
        switch (clientMessage.messageType) {
            case "GET_CLIENT_ID": {
                this.setClientId(out);
                break;
            }
            case "GET_REQUEST": {
                this.sendCurrentRequest(clientMessage, out);
                break;
            }
            default: {
                this.processRequestResult(clientMessage, out);
            }
        }
    }

    private void sendCurrentRequest(ClientMessage clientMessage, OutputStream out) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (PrintWriter pw = new PrintWriter(out, true);){
                pw.print(this.getStringCurrentRequest(clientMessage));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private void setClientId(OutputStream out) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (PrintWriter pw = new PrintWriter(out, true);){
                pw.print(KatalonRequestHandler.nextClientId());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex);
        }
    }

    private static synchronized int nextClientId() {
        return ++clientId;
    }

    private String getStringCurrentRequest(ClientMessage clientMessage) {
        if (this.currentRequest == null || this.currentRequest.getRequestId() <= clientMessage.prevRequestId) {
            return "NO_REQUEST";
        }
        if (this.currentRequest instanceof HighlightRequest && !((HighlightRequest)this.currentRequest).isFound()) {
            return String.valueOf(this.currentRequest.getRequestId()) + "_|_" + "FIND_TEST_OBJECT" + "_|_" + this.currentRequest.getData();
        }
        if (this.currentRequest instanceof HighlightRequest && ((HighlightRequest)this.currentRequest).isFound()) {
            if (((HighlightRequest)this.currentRequest).getClientId() == clientMessage.clientId) {
                return String.valueOf(this.currentRequest.getRequestId()) + "_|_" + "HIGHLIGHT_TEST_OBJECT" + "_|_" + this.currentRequest.getData();
            }
            return "NO_REQUEST";
        }
        return String.valueOf(this.currentRequest.getRequestId()) + "_|_" + this.currentRequest.getRequestType() + "_|_" + this.currentRequest.getData();
    }

    public void processRequestResult(ClientMessage clientMessage, OutputStream out) {
        if (this.currentRequest.getRequestId() != clientMessage.prevRequestId) {
            return;
        }
        switch (this.currentRequest.getRequestType()) {
            case "HIGHLIGHT_TEST_OBJECT": {
                this.processHighlightObjectResult(clientMessage, out);
            }
        }
    }

    public synchronized void removeCurrentRequest() {
        if (this.currentRequest == null) {
            return;
        }
        if (this.currentRequest.isFailed() && this.requestFailedListener != null) {
            this.requestFailedListener.requestFailed(this.currentRequest.processFailed());
        }
        this.currentRequest = null;
    }

    private synchronized void processHighlightObjectResult(ClientMessage clientMessage, OutputStream out) {
        if (clientMessage.messageType.equals("FOUND") && clientMessage.prevRequestId == this.currentRequest.getRequestId()) {
            HighlightRequest highlightRequest = (HighlightRequest)this.currentRequest;
            highlightRequest.setSuccess(true);
            highlightRequest.setFound(true);
            highlightRequest.setClientId(clientMessage.clientId);
            highlightRequest.nextRequestId();
            this.sendCurrentRequest(clientMessage, out);
        }
    }
}

