/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.dialog;

import com.kms.katalon.composer.components.controls.HelpCompositeForDialog;
import com.kms.katalon.composer.components.impl.control.GifCLabel;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.services.UISynchronizeService;
import com.kms.katalon.composer.components.util.ColorUtil;
import com.kms.katalon.constants.DocumentationMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.core.testobject.SelectorMethod;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.webui.common.WebUiCommonHelper;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.constants.ObjectspyMessageConstants;
import com.kms.katalon.objectspy.core.InspectSession;
import com.kms.katalon.objectspy.dialog.ObjectSpyEvent;
import com.kms.katalon.objectspy.element.WebElement;
import com.kms.katalon.objectspy.element.WebPage;
import com.kms.katalon.objectspy.element.WebParent;
import com.kms.katalon.objectspy.highlight.HighlightRequest;
import com.kms.katalon.objectspy.util.FileUtil;
import com.kms.katalon.objectspy.util.WebElementUtils;
import com.kms.katalon.objectspy.websocket.AddonCommand;
import com.kms.katalon.objectspy.websocket.AddonSocket;
import com.kms.katalon.objectspy.websocket.messages.AddonMessage;
import com.kms.katalon.util.listener.EventListener;
import com.kms.katalon.util.listener.EventManager;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ObjectVerifyAndHighlightView
implements EventListener<ObjectSpyEvent>,
EventManager<ObjectSpyEvent> {
    private static final String WEB_ELEMENT_SCREENSHOT_PROPERTY = "screenshot";
    private static final String HIGHLIGHT_JS_PATH = "/resources/js/highlight.js";
    private Label lblMessageVerifyObject;
    private Button btnVerifyAndHighlight;
    private Composite connectingComposite;
    private Button btnAddScreenShotForElement;
    private GifCLabel connectingLabel;
    private InputStream inputStream;
    private Label lblConnecting;
    private String highlightJS;
    private WebElement webElement;
    private InspectSession seleniumSession;
    private AddonSocket activeBrowserSession;
    private static String DOCUMENT_QUERY_SELECTOR = "return document.querySelector";
    private static String SHADOW_DOM_QUERY_SELECTOR = ".shadowRoot.querySelector";
    private Map<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>> eventListeners = new HashMap<ObjectSpyEvent, Set<EventListener<ObjectSpyEvent>>>();

    private String getHighlightJS() {
        if (this.highlightJS == null) {
            this.highlightJS = this.loadHighlightJSFromResource();
        }
        return this.highlightJS;
    }

    private String loadHighlightJSFromResource() {
        try {
            URL url = FileLocator.find((Bundle)FrameworkUtil.getBundle(ObjectVerifyAndHighlightView.class), (IPath)new Path(HIGHLIGHT_JS_PATH), null);
            return StringUtils.join((Collection)IOUtils.readLines((InputStream)new BufferedInputStream(url.openStream()), (String)"UTF-8"), (String)"\n");
        }
        catch (IOException e) {
            LoggerSingleton.logError((Throwable)e);
            return "";
        }
    }

    public Composite createVerifyAndHighlightView(Composite parent, int layoutStyle) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(layoutStyle));
        GridLayout gdVerifyView = new GridLayout(5, false);
        gdVerifyView.marginWidth = 0;
        composite.setLayout((Layout)gdVerifyView);
        this.connectingComposite = new Composite(composite, 0);
        this.connectingComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.connectingComposite.setLayout((Layout)new GridLayout(2, false));
        this.connectingLabel = new GifCLabel(this.connectingComposite, 0x20000000);
        this.connectingLabel.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.lblConnecting = new Label(this.connectingComposite, 0);
        this.lblConnecting.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.lblConnecting.setText(ObjectspyMessageConstants.DIA_MSG_VERIFYING);
        this.connectingComposite.setVisible(false);
        this.lblMessageVerifyObject = new Label(composite, 0);
        this.lblMessageVerifyObject.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnVerifyAndHighlight = new Button(composite, 0x800000);
        this.btnVerifyAndHighlight.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnVerifyAndHighlight.setText(ObjectspyMessageConstants.DIA_LBL_VERIFY_AND_HIGHLIGHT);
        this.btnAddScreenShotForElement = new Button(composite, 0x800000);
        this.btnAddScreenShotForElement.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.btnAddScreenShotForElement.setText(ObjectspyMessageConstants.DIA_LBL_ADD_SCREENSHOT);
        new HelpCompositeForDialog(composite, DocumentationMessageConstants.DIALOG_OBJECT_SPY_WEB_UI){

            protected GridData createGridData() {
                return new GridData(16384, 0x1000000, false, false);
            }

            protected GridLayout createLayout() {
                GridLayout layout = new GridLayout();
                layout.marginBottom = 0;
                layout.marginWidth = 0;
                return layout;
            }
        };
        this.registerControlModifyListeners();
        this.onElementChanged();
        return composite;
    }

    private void registerControlModifyListeners() {
        this.btnVerifyAndHighlight.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObjectVerifyAndHighlightView.this.clearMessage();
                Thread highlightThread = new Thread(() -> {
                    try {
                        ObjectVerifyAndHighlightView.this.setConnectingCompositeVisibleSync(true);
                        if (ObjectVerifyAndHighlightView.this.seleniumSession != null) {
                            this.highlightElementUsingSelenium();
                            return;
                        }
                        if (ObjectVerifyAndHighlightView.this.activeBrowserSession != null) {
                            this.highlightElementUsingAddon();
                            return;
                        }
                    }
                    finally {
                        ObjectVerifyAndHighlightView.this.setConnectingCompositeVisibleSync(false);
                    }
                });
                highlightThread.start();
            }

            private void highlightElementUsingAddon() {
                String xpathExpression = new HighlightRequest(ObjectVerifyAndHighlightView.this.webElement).getData();
                ObjectVerifyAndHighlightView.this.activeBrowserSession.sendMessage(new AddonMessage(AddonCommand.HIGHLIGHT_OBJECT, xpathExpression));
            }

            private void highlightElementUsingSelenium() {
                WebDriver webDriver = null;
                String selector = "";
                try {
                    webDriver = ObjectVerifyAndHighlightView.this.seleniumSession.getWebDriver();
                    if (webDriver == null || ObjectVerifyAndHighlightView.this.isBrowserClosed(webDriver)) {
                        ObjectVerifyAndHighlightView.this.displayErrorMessageSync(ObjectspyMessageConstants.DIA_MSG_BROWSER_NOT_STARTED);
                        return;
                    }
                    webDriver.manage().timeouts().implicitlyWait(100L, TimeUnit.MILLISECONDS);
                    if (ObjectVerifyAndHighlightView.this.webElement.getWindowTitle() != null && !ObjectVerifyAndHighlightView.this.webElement.getWindowTitle().isEmpty() && webDriver.getTitle() != ObjectVerifyAndHighlightView.this.webElement.getWindowTitle()) {
                        WebUiCommonHelper.switchToWindowUsingTitle((WebDriver)webDriver, (String)ObjectVerifyAndHighlightView.this.webElement.getWindowTitle(), (int)1);
                    }
                    List<Object> webElements = new ArrayList<org.openqa.selenium.WebElement>();
                    WebParent webParent = ObjectVerifyAndHighlightView.this.webElement.getParent();
                    if (webParent != null) {
                        WebElement.WebElementType type = webParent.getType();
                        switch (type) {
                            case FRAME: 
                            case SHADOW: {
                                this.switchToFrame(webDriver, ObjectVerifyAndHighlightView.this.webElement);
                                break;
                            }
                        }
                        if (ObjectVerifyAndHighlightView.this.webElement.getSelectorMethod() == SelectorMethod.SMART_LOCATOR) {
                            String jsLocator = ObjectVerifyAndHighlightView.this.getSmartLocatorFromElement(ObjectVerifyAndHighlightView.this.webElement);
                            org.openqa.selenium.WebElement elementFindBySmartLocator = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(jsLocator, new Object[0]);
                            webElements.add(elementFindBySmartLocator);
                        }
                        if (ObjectVerifyAndHighlightView.this.webElement.getSelectorMethod() == SelectorMethod.CSS && type == WebElement.WebElementType.SHADOW) {
                            String script = String.valueOf(DOCUMENT_QUERY_SELECTOR) + ObjectVerifyAndHighlightView.this.getCssSelectorFromShadowDom(ObjectVerifyAndHighlightView.this.webElement) + ";";
                            org.openqa.selenium.WebElement elementFindByCSS = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
                            webElements.add(elementFindByCSS);
                        }
                        selector = ObjectVerifyAndHighlightView.this.webElement.getSelectorMethod().getName();
                        if (webElements.size() == 0) {
                            By seleniumSelector = ObjectVerifyAndHighlightView.this.getSeleniumSelector(ObjectVerifyAndHighlightView.this.webElement);
                            if (seleniumSelector == null) {
                                return;
                            }
                            selector = ObjectVerifyAndHighlightView.this.getSelectorName(seleniumSelector);
                            webElements = webDriver.findElements(seleniumSelector);
                        }
                    }
                    if (webElements.size() == 0) {
                        ObjectVerifyAndHighlightView.this.displayErrorMessageSync(MessageFormat.format(ObjectspyMessageConstants.DIA_UNABLE_TO_FIND_OBJECT_USING_Y_SELECTOR, selector));
                        return;
                    }
                    try {
                        ObjectVerifyAndHighlightView.this.displayWebElementsFoundMessageSync(webElements.size(), selector);
                        UISynchronizeService.syncExec(() -> {
                            ObjectVerifyAndHighlightView.this.lblConnecting.setText(ObjectspyMessageConstants.DIA_MSG_HIGHLIGHTING);
                            ObjectVerifyAndHighlightView.this.connectingComposite.getParent().layout(true, true);
                        });
                        this.highlightElements(webDriver, webElements);
                    }
                    catch (InterruptedException | WebDriverException throwable) {
                        ObjectVerifyAndHighlightView.this.displayErrorMessageSync(MessageFormat.format(ObjectspyMessageConstants.DIA_UNABLE_TO_FIND_OBJECT_USING_Y_SELECTOR, selector));
                    }
                }
                finally {
                    if (webDriver != null || ObjectVerifyAndHighlightView.this.isBrowserClosed(webDriver)) {
                        webDriver.switchTo().defaultContent();
                    }
                }
            }

            private void highlightElements(WebDriver webDriver, List<org.openqa.selenium.WebElement> webElements) {
                if (webDriver instanceof JavascriptExecutor) {
                    JavascriptExecutor jsExecutor = (JavascriptExecutor)webDriver;
                    org.openqa.selenium.WebElement firstElement = webElements.get(0);
                    boolean isInViewPort = (Boolean)((JavascriptExecutor)webDriver).executeScript("var elem = arguments[0],                   box = elem.getBoundingClientRect(),      cx = box.left + box.width / 2,           cy = box.top + box.height / 2,           e = document.elementFromPoint(cx, cy); for (; e; e = e.parentElement) {           if (e === elem)                            return true;                         }                                        return false;                            ", new Object[]{firstElement});
                    if (!isInViewPort) {
                        jsExecutor.executeScript("arguments[0].scrollIntoView({ behavior: 'auto',          block: 'center',           inline: 'center'           });                       ", new Object[]{firstElement});
                    }
                    String highlightJS = ObjectVerifyAndHighlightView.this.getHighlightJS();
                    webElements.parallelStream().forEach(element -> jsExecutor.executeScript(highlightJS, new Object[]{element}));
                }
            }

            private void switchToFrame(WebDriver webDriver, WebElement katalonElement) {
                WebParent parentElement = katalonElement.getParent();
                if (parentElement == null || parentElement.getType() == WebElement.WebElementType.PAGE) {
                    return;
                }
                org.openqa.selenium.WebElement parentSeleniumElement = null;
                boolean isFrame = false;
                this.switchToFrame(webDriver, parentElement);
                if (parentElement.getSelectorMethod() == SelectorMethod.SMART_LOCATOR) {
                    String jsLocator = ObjectVerifyAndHighlightView.this.getSmartLocatorFromElement(parentElement);
                    parentSeleniumElement = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(jsLocator, new Object[0]);
                } else {
                    List elements;
                    if (parentElement.getType() == WebElement.WebElementType.FRAME && (elements = webDriver.findElements(ObjectVerifyAndHighlightView.this.getSeleniumSelector(parentElement))).size() > 0) {
                        parentSeleniumElement = (org.openqa.selenium.WebElement)elements.get(0);
                    }
                    if (parentElement.getType() == WebElement.WebElementType.SHADOW) {
                        String script = String.valueOf(DOCUMENT_QUERY_SELECTOR) + ObjectVerifyAndHighlightView.this.getCssSelectorFromShadowDom(katalonElement) + ";";
                        parentSeleniumElement = (org.openqa.selenium.WebElement)((JavascriptExecutor)webDriver).executeScript(script, new Object[0]);
                    }
                }
                if (parentSeleniumElement == null) {
                    return;
                }
                String tagName = parentSeleniumElement.getTagName();
                if ("iFrame".equalsIgnoreCase(tagName) || "frame".equalsIgnoreCase(tagName)) {
                    isFrame = true;
                }
                if (isFrame) {
                    webDriver.switchTo().frame(parentSeleniumElement);
                }
            }
        });
        this.btnAddScreenShotForElement.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Thread addScreenShotThread = new Thread(() -> {
                    try {
                        if (ObjectVerifyAndHighlightView.this.seleniumSession == null) {
                            ObjectVerifyAndHighlightView.this.displayErrorMessageSync(ObjectspyMessageConstants.FAIL_TO_TAKE_SCREENSHOT);
                            return;
                        }
                        try {
                            ObjectVerifyAndHighlightView.this.setConnectingCompositeVisibleSync(true);
                            WebDriver driver = ObjectVerifyAndHighlightView.this.seleniumSession.getWebDriver();
                            String pathToImage = WebElementUtils.takeScreenShotForImageBasedObjectRecognition(driver, ObjectVerifyAndHighlightView.this.webElement);
                            String projectDir = ProjectController.getInstance().getCurrentProject().getFolderLocation();
                            String relativePathToImage = FileUtil.getRelativePath(pathToImage, projectDir);
                            ObjectVerifyAndHighlightView.this.webElement.getSelectorCollection().put(SelectorMethod.IMAGE, relativePathToImage);
                            ObjectVerifyAndHighlightView.this.displaySuccessfulMessageSync(ObjectspyMessageConstants.SCREENSHOT_TAKEN);
                            ObjectVerifyAndHighlightView.this.invoke((Object)ObjectSpyEvent.ELEMENT_PROPERTIES_CHANGED, ObjectVerifyAndHighlightView.this.webElement);
                        }
                        catch (Exception ex) {
                            LoggerSingleton.logError((Throwable)ex);
                        }
                    }
                    finally {
                        ObjectVerifyAndHighlightView.this.setConnectingCompositeVisibleSync(false);
                    }
                });
                addScreenShotThread.start();
            }
        });
    }

    private void onElementChanged() {
        this.changeBtnAddScreenShotState();
        this.changeBtnVerifyAndHighlightState();
    }

    private void changeBtnAddScreenShotState() {
        if (this.btnAddScreenShotForElement.isDisposed()) {
            return;
        }
        this.btnAddScreenShotForElement.setEnabled(this.webElement != null && this.seleniumSession != null);
    }

    private void changeBtnVerifyAndHighlightState() {
        if (this.btnVerifyAndHighlight.isDisposed()) {
            return;
        }
        boolean allowEnable = false;
        if (this.webElement != null) {
            SelectorMethod selectorMethod = this.webElement.getSelectorMethod();
            String selectorValue = this.webElement.getSelectorCollection().get(selectorMethod);
            if (!StringUtils.isBlank((String)selectorValue)) {
                allowEnable = true;
            }
        }
        this.btnVerifyAndHighlight.setEnabled(allowEnable);
    }

    private By getSeleniumSelector(WebElement webElement) {
        SelectorMethod selectorMethod = webElement.getSelectorMethod();
        String selectorValue = webElement.getSelectorCollection().get(selectorMethod);
        switch (selectorMethod) {
            case BASIC: {
                TestObject testObject = WebElementUtils.buildTestObject(webElement);
                return WebUiCommonHelper.buildLocator((TestObject)testObject);
            }
            case CSS: {
                if (StringUtils.isEmpty((String)selectorValue)) {
                    return null;
                }
                return By.cssSelector((String)selectorValue);
            }
            case XPATH: {
                if (StringUtils.isEmpty((String)selectorValue)) {
                    return null;
                }
                return By.xpath((String)selectorValue);
            }
        }
        return null;
    }

    private String getSelectorName(By by) {
        if (by instanceof By.ByCssSelector) {
            return "CSS";
        }
        return "XPath";
    }

    private void displaySuccessfulMessageSync(String message) {
        UISynchronizeService.syncExec(() -> {
            this.lblMessageVerifyObject.setForeground(ColorUtil.getTextSuccessfulColor());
            this.lblMessageVerifyObject.setText(message);
            this.lblMessageVerifyObject.getParent().getParent().layout(true);
        });
    }

    private void displayErrorMessageSync(String message) {
        UISynchronizeService.syncExec(() -> {
            this.lblMessageVerifyObject.setForeground(ColorUtil.getTextErrorColor());
            this.lblMessageVerifyObject.setText(message);
            this.lblMessageVerifyObject.getParent().getParent().layout(true);
        });
    }

    private void displayWebElementsFoundMessageSync(int numElements, String selector) {
        String pluralPostfix = numElements > 1 ? "s" : "";
        this.displaySuccessfulMessageSync(MessageFormat.format(ObjectspyMessageConstants.DIA_MSG_FOUND_X_ELEMENTS_USING_Y_SELECTOR, numElements, pluralPostfix, selector));
    }

    private void clearMessage() {
        this.lblMessageVerifyObject.setText("");
        this.lblMessageVerifyObject.getParent().layout(true);
    }

    private boolean isBrowserClosed(WebDriver webDriver) {
        try {
            webDriver.getTitle();
            return false;
        }
        catch (WebDriverException webDriverException) {
            return true;
        }
    }

    private void setConnectingCompositeVisibleSync(boolean isConnectingCompositeVisible) {
        UISynchronizeService.syncExec(() -> {
            block11: {
                if (isConnectingCompositeVisible) {
                    try {
                        try {
                            this.inputStream = ImageConstants.URL_16_LOADING.openStream();
                            this.connectingLabel.setGifImage(this.inputStream);
                        }
                        catch (IOException iOException) {
                            if (this.inputStream != null) {
                                IOUtils.closeQuietly((InputStream)this.inputStream);
                                this.inputStream = null;
                            }
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        if (this.inputStream != null) {
                            IOUtils.closeQuietly((InputStream)this.inputStream);
                            this.inputStream = null;
                        }
                        throw throwable;
                    }
                    if (this.inputStream != null) {
                        IOUtils.closeQuietly((InputStream)this.inputStream);
                        this.inputStream = null;
                    }
                } else if (this.inputStream != null) {
                    IOUtils.closeQuietly((InputStream)this.inputStream);
                    this.inputStream = null;
                }
            }
            this.connectingComposite.setVisible(isConnectingCompositeVisible);
            this.btnVerifyAndHighlight.setEnabled(!isConnectingCompositeVisible);
            this.btnAddScreenShotForElement.setEnabled(!isConnectingCompositeVisible);
            this.connectingComposite.getParent().layout(true, true);
        });
    }

    public void handleEvent(ObjectSpyEvent event, Object object) {
        switch (event) {
            case SELENIUM_SESSION_STARTED: {
                this.seleniumSession = (InspectSession)object;
                this.activeBrowserSession = null;
                this.onElementChanged();
                return;
            }
            case ADDON_SESSION_STARTED: {
                this.activeBrowserSession = (AddonSocket)object;
                this.seleniumSession = null;
                this.onElementChanged();
                break;
            }
            case SELECTOR_HAS_CHANGED: 
            case SELECTED_ELEMENT_CHANGED: 
            case ELEMENT_PROPERTIES_CHANGED: {
                this.webElement = (WebElement)object;
                if (this.webElement instanceof WebPage) {
                    this.webElement = null;
                }
                this.onElementChanged();
                return;
            }
            default: {
                return;
            }
        }
    }

    public Iterable<EventListener<ObjectSpyEvent>> getListeners(ObjectSpyEvent event) {
        return this.eventListeners.get((Object)event);
    }

    public void addListener(EventListener<ObjectSpyEvent> listener, Iterable<ObjectSpyEvent> events) {
        events.forEach(e -> {
            Set<EventListener<ObjectSpyEvent>> listenerOnEvent = this.eventListeners.get(e);
            if (listenerOnEvent == null) {
                listenerOnEvent = new HashSet<EventListener<ObjectSpyEvent>>();
            }
            listenerOnEvent.add(listener);
            this.eventListeners.put((ObjectSpyEvent)((Object)e), listenerOnEvent);
        });
    }

    public String getCssSelectorFromShadowDom(WebElement webElement) {
        String cssSelector = "('" + webElement.getSelectorCollection().get(SelectorMethod.CSS) + "')";
        WebParent webParent = webElement.getParent();
        if (webParent != null && WebElement.WebElementType.SHADOW == webParent.getType()) {
            cssSelector = String.valueOf(this.getCssSelectorFromShadowDom(webParent)) + SHADOW_DOM_QUERY_SELECTOR + cssSelector;
        }
        return cssSelector;
    }

    public String getSmartLocatorFromElement(WebElement webElement) {
        String smartLocator = webElement.getSelectorCollection().get(SelectorMethod.SMART_LOCATOR);
        String jsLocator = String.format("return katalonSmartLocator.find_element_by_smart_locator(`%s`)", smartLocator);
        return jsLocator;
    }
}

