/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.objectspy.element.tree;

import com.kms.katalon.constants.GlobalStringConstants;
import com.kms.katalon.objectspy.constants.ImageConstants;
import com.kms.katalon.objectspy.element.ConflictWebElementWrapper;
import com.kms.katalon.objectspy.element.tree.WebElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ConflictStatusWebElementLabelProvider
extends CellLabelProvider {
    private WebElementLabelProvider webElementProvider = new WebElementLabelProvider();

    public void update(ViewerCell cell) {
        String name = GlobalStringConstants.EMPTY;
        if (cell.getElement() != null && cell.getElement() instanceof ConflictWebElementWrapper) {
            name = ((ConflictWebElementWrapper)cell.getElement()).getOriginalWebElement().getName();
        }
        this.setColor(cell);
        cell.setText(name);
        cell.setImage(this.getImage(cell.getElement()));
    }

    private void setColor(ViewerCell cell) {
        Object element = cell.getElement();
        if (element == null || !(element instanceof ConflictWebElementWrapper)) {
            return;
        }
        ConflictWebElementWrapper htmlElement = (ConflictWebElementWrapper)element;
        if (htmlElement.isConflicted()) {
            cell.setForeground(Display.getCurrent().getSystemColor(3));
        }
    }

    private Image getImage(Object element) {
        if (!(element instanceof ConflictWebElementWrapper)) {
            return null;
        }
        ConflictWebElementWrapper htmlElement = (ConflictWebElementWrapper)element;
        Image baseImage = this.webElementProvider.getImage(htmlElement.getOriginalWebElement());
        Image overlayImage = htmlElement.isConflicted() ? ImageConstants.IMG_16_CONFLICT_ELEMENT_STATUS : ImageConstants.IMG_16_NEW_ELEMENT_STATUS;
        return this.combineTwoImages(baseImage, overlayImage);
    }

    private Image combineTwoImages(Image baseImage, Image overlayImage) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[4] = ImageDescriptor.createFromImage((Image)baseImage);
        DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(overlayImage, imageDescriptorArray, new Point(baseImage.getBounds().width, baseImage.getBounds().height));
        return decoratedImage.createImage();
    }
}

