package com.kms.katalon.core.logging.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.apache.commons.text.StringEscapeUtils;

import com.kms.katalon.core.helper.LogRecordHelper;


public class TestCaseLogRecord extends AbstractLogRecord {
    private boolean isOptional;

    private String tag;
    
    private String iterationVariableValue;

    public TestCaseLogRecord(String name) {
        super(name);
        setType(ILogRecord.LOG_TYPE_TEST_CASE);
    }

    /**
     * Returns if the result of current test case is optional or not.
     * <p>
     * Used when the current test case is called by another test case.
     * 
     * @return true if result of this is optional. Otherwise, false.
     */
    public boolean isOptional() {
        return isOptional;
    }

    public void setOptional(boolean isOptional) {
        this.isOptional = isOptional;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
    
    public String getIterationVariableValue() {
        return iterationVariableValue;
    }
    
    public void setIterationVariableValue(String iterationVariableValue) {
        this.iterationVariableValue = iterationVariableValue;
    }

    /**
     * 
     * @return true only if running test Suite with RetryImmediately mode and this test case is the retry one
     */
    public boolean isRetryTestCase() {
        return LogRecordHelper.getRetyCount(this) > 0;
    }

    @Override
    public ILogRecord[] getChildRecords() {
        List<ILogRecord> resultRecords = new ArrayList<ILogRecord>();
        for (ILogRecord logRecord : childRecords) {
            if (logRecord instanceof TestStepLogRecord) {
                logRecord.setDescription(StringEscapeUtils.unescapeJava(logRecord.getDescription()));
                resultRecords.add(logRecord);
            }
        }
        return resultRecords.toArray(new ILogRecord[resultRecords.size()]);
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = super.hashCode();
        result = prime * result + Objects.hash(isOptional, tag);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TestCaseLogRecord)) {
            return false;
        }
        if (LogRecordHelper.getRetyCount(this) != LogRecordHelper.getRetyCount((TestCaseLogRecord) obj)) {
            return false;
        }
        TestCaseLogRecord other = (TestCaseLogRecord) obj;
        return isOptional == other.isOptional && Objects.equals(tag, other.tag);
    }
}
