package com.kms.katalon.core.setting;

import java.io.IOException;

import com.kms.katalon.core.configuration.RunConfiguration;

public class ReportBundleSettingStore {
    
    private BundleSettingStore bundleSettingStore;
    
    public ReportBundleSettingStore() {
        bundleSettingStore = new BundleSettingStore(RunConfiguration.getProjectDir(), "com.katalon.plugin.report",true);
    }
    
    public ReportBundleSettingStore(String projectDir) {
        bundleSettingStore = new BundleSettingStore(projectDir, "com.katalon.plugin.report",true);
    }
    
    public ReportBundleSettingStore(BundleSettingStore bundleSettingStore) {
        this.bundleSettingStore = bundleSettingStore;
    }
    
    public boolean canGenerateHTLM() throws IOException {
        return bundleSettingStore.getBoolean("generateHTML", true);
    }
    
    public boolean canGengerateCSV() throws IOException {
        return bundleSettingStore.getBoolean("generateCSV", true);
    }
    
    public boolean canGengeratePDF() throws IOException {
        return bundleSettingStore.getBoolean("generatePDF", false);
    }
}
