package com.kms.katalon.core.util;

import static com.kms.katalon.core.network.HttpClientProxyBuilder.create;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.text.MessageFormat;

import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kms.katalon.core.network.HttpClientProxyBuilder;
import com.kms.katalon.core.preferences.ProxyPreferences;
import com.kms.katalon.logging.LogUtil;

public class HttpClientUtil {
	public static String executeRequest(HttpUriRequest httpRequest, boolean isSilent)
			throws ParseException, IOException, URISyntaxException, GeneralSecurityException, HttpClientException {
		HttpClientProxyBuilder httpClientProxyBuilder = create(ProxyPreferences.getAuthProxyInformation(),
				httpRequest.getURI().toURL().toString());

		HttpClient httpClient = httpClientProxyBuilder.getClientBuilder().build();
		HttpResponse httpResponse = httpClient.execute(httpRequest);
		int statusCode = httpResponse.getStatusLine().getStatusCode();

		HttpEntity entity = httpResponse.getEntity();
		String responseString = StringUtils.EMPTY;
		if (entity != null) {
			responseString = EntityUtils.toString(httpResponse.getEntity(), StandardCharsets.UTF_8);
		}

		if (statusCode == HttpStatus.SC_OK || statusCode == HttpStatus.SC_CREATED
				|| statusCode == HttpStatus.SC_NO_CONTENT) {
			return responseString;
		}

		if (500 <= statusCode && statusCode <= 599) {
			throw new HttpClientException(String.valueOf(statusCode));
		}

		if (!isSilent) {
			LogUtil.logError(MessageFormat.format("Unexpected response, URL: {0}, Status: {1}, Response: {2}",
					httpRequest.getURI().toString(), statusCode, responseString));
		}

		throw new HttpClientException(responseString);
	}

	public static <T> T executeRequest(HttpUriRequest httpRequest, boolean isSilent, Class<T> returnType)
			throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
		String responseString = executeRequest(httpRequest, isSilent);
		Gson gson = new GsonBuilder().create();
		return gson.fromJson(responseString, returnType);
	}

	public static <T> T executeRequest(HttpUriRequest httpRequest, Class<T> returnType)
			throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
		String responseString = executeRequest(httpRequest, false);
		Gson gson = new GsonBuilder().create();
		return gson.fromJson(responseString, returnType);
	}

	public static <T> T executeRequest(HttpUriRequest httpRequest, boolean isSilent, TypeToken<T> typeToken)
			throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
		String responseString = executeRequest(httpRequest, isSilent);
		Gson gson = new GsonBuilder().create();
		return gson.fromJson(responseString, typeToken.getType());
	}

	public static <T> T executeRequest(HttpUriRequest httpRequest, TypeToken<T> typeToken)
			throws ParseException, HttpClientException, IOException, URISyntaxException, GeneralSecurityException {
		String responseString = executeRequest(httpRequest, false);
		Gson gson = new GsonBuilder().create();
		return gson.fromJson(responseString, typeToken.getType());
	}
}
