package com.kms.katalon.core.mobile.helper;

import java.text.MessageFormat;
import java.util.Map;

import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.util.internal.JsonUtil;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;

public final class AndroidHelper {

    private AndroidHelper() {
    }

    private static final KeywordLogger logger = KeywordLogger.getInstance(AndroidHelper.class);

    public static int getStatusBarHeight(AppiumDriver<? extends WebElement> driver) {
        int statusBar = 0;
        try {
            statusBar = getStatusBarByProperty(driver);
        } catch (WebDriverException e) {
            logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "getSystemBar"));
        }

        if (statusBar == 0) {
            try {
                return getStatusBarHeightByCommand(driver);
            } catch (WebDriverException e) {
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "viewportRect"));
            }
        }
        return statusBar;
    }

    @SuppressWarnings("rawtypes")
    private static int getStatusBarByProperty(AppiumDriver<? extends WebElement> driver) throws WebDriverException {
        Map<String, String> bars = ((AndroidDriver) driver).getSystemBars();
        AndroidSystemBarProperties barsProps = JsonUtil.fromJson(JsonUtil.toJson(bars),
                AndroidSystemBarProperties.class);
        OSBarProperties statusBar = barsProps.getStatusBar();
        if (statusBar != null && statusBar.getWidth() > 0 && statusBar.getHeight() > 0) {
            return statusBar.getHeight();
        }
        return 0;
    }

    private static int getStatusBarHeightByCommand(AppiumDriver<? extends WebElement> driver) {
        Object res = driver.executeScript("mobile:viewportRect");
        ViewportRect vp = JsonUtil.fromJson(res.toString(), ViewportRect.class);
        return vp.top == 0 ? 0 : (int) vp.top;
    }
}

class ViewportRect {
    public int left;

    public int top;

    public int height;

    public int width;

    public int getLeft() {
        return left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

}

class AndroidSystemBarProperties {
    private OSBarProperties statusBar;

    private OSBarProperties navigationBar;

    public OSBarProperties getStatusBar() {
        return statusBar;
    }

    public void setStatusBar(OSBarProperties statusBar) {
        this.statusBar = statusBar;
    }

    public OSBarProperties getNavigationBar() {
        return navigationBar;
    }

    public void setNavigationBar(OSBarProperties navigationBar) {
        this.navigationBar = navigationBar;
    }

}

class OSBarProperties {
    private int x;

    private int y;

    private int width;

    private int height;

    private boolean visible;

    public int getX() {
        return x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean isVisible() {
        return visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public OSBarProperties(int x, int y, int width, int height, boolean visible) {
        super();
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.visible = visible;
    }
}
