package com.kms.katalon.core.mobile.helper;

import java.text.MessageFormat;

import org.openqa.selenium.Dimension;
import org.openqa.selenium.WebElement;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.driver.AppiumSessionCollector;
import com.kms.katalon.core.mobile.exception.MobileException;
import com.kms.katalon.core.util.internal.JsonUtil;

import io.appium.java_client.AppiumDriver;
import io.appium.java_client.ios.IOSDriver;

public final class IOSHelper {

    private IOSHelper() {
    }

    private static final KeywordLogger logger = KeywordLogger.getInstance(IOSHelper.class);

    public static int getStatusBarHeight(AppiumDriver<? extends WebElement> driver) {
        int statusBarHeight = 0;
        IOSDriver<? extends WebElement> iosDriver = (IOSDriver<? extends WebElement>) driver;
        try {
            DeviceScreenInfo deviceScreenInfo = getDeviceScreenInfo(iosDriver);
            StatusBarSize statusBarSize = deviceScreenInfo.getStatusBarSize();
            statusBarHeight = (int) (statusBarSize.getHeight() * deviceScreenInfo.getScale());
        } catch (Exception e) {
            logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect = getDeviceViewPortRect(iosDriver);
                int scale = deviceViewPortRect.getWidth() / screenSize.getWidth();
                statusBarHeight = deviceViewPortRect.getTop() / scale;
            } catch (Exception ex) {
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT + " " + ex.getMessage());
                logger.logInfo(MessageFormat.format(StringConstants.KW_LOG_FAILED_GET_OS_STATUSBAR, "Screenshot"));
            }
        }
        return statusBarHeight;
    }

    public static float getScaleFactor(AppiumDriver<? extends WebElement> driver) {
        float scaleFactor = 1;
        try {
            DeviceScreenInfo deviceScreenInfo = IOSHelper.getDeviceScreenInfo(driver);
            scaleFactor = deviceScreenInfo.getScale();
        } catch (Exception e) {
            logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_SCREEN_INFO + " " + e.getMessage());
            try {
                Dimension screenSize = driver.manage().window().getSize();
                DeviceViewPortRect deviceViewPortRect;
                deviceViewPortRect = IOSHelper.getDeviceViewPortRect(driver);
                scaleFactor = deviceViewPortRect.getWidth() / screenSize.getWidth();
            } catch (Exception ex) {
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_DEVICE_VIEWPORT_RECT + " " + e.getMessage());
                logger.logInfo(StringConstants.KW_LOG_FAILED_GET_SCALE_FACTOR);
            }
        }
        return scaleFactor;
    }

    public static String getActiveAppBundleIdFromSession(AppiumDriver<? extends WebElement> driver) {
        return (String) AppiumSessionCollector.getSession(driver)
                .getProperties()
                .get(MobileCommonHelper.PROPERTY_NAME_IOS_BUNDLEID);
    }

    private static DeviceScreenInfo getDeviceScreenInfo(AppiumDriver<? extends WebElement> driver)
            throws MobileException {
        IOSDriver<? extends WebElement> iosDriver = (IOSDriver<? extends WebElement>) driver;
        Object info = iosDriver.executeScript("mobile: deviceScreenInfo");
        if (info == null) {
            throw new MobileException("The raw data is null.");
        }

        DeviceScreenInfo deviceScreenInfo = JsonUtil.fromJson(info.toString(), DeviceScreenInfo.class);
        if (deviceScreenInfo == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }

        return deviceScreenInfo;
    }

    private static DeviceViewPortRect getDeviceViewPortRect(AppiumDriver<? extends WebElement> driver)
            throws MobileException {
        IOSDriver<? extends WebElement> iosDriver = (IOSDriver<? extends WebElement>) driver;
        Object rect = iosDriver.executeScript("mobile: viewportRect");
        if (rect == null) {
            throw new MobileException("The raw data is null.");
        }

        DeviceViewPortRect deviceViewPortRect = JsonUtil.fromJson(rect.toString(), DeviceViewPortRect.class);
        if (deviceViewPortRect == null) {
            throw new MobileException("Failed to parse the raw data to object.");
        }

        return deviceViewPortRect;
    }
}

class DeviceViewPortRect {
    public int left;

    public int top;

    public int width;

    public int height;

    public int getLeft() {
        return left;
    }

    public void setLeft(int left) {
        this.left = left;
    }

    public int getTop() {
        return top;
    }

    public void setTop(int top) {
        this.top = top;
    }

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}

class DeviceScreenInfo {
    // https://developer.apple.com/documentation/uikit/uiscreen/1617836-scale
    public float scale;

    public StatusBarSize statusBarSize;

    public float getScale() {
        return scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public StatusBarSize getStatusBarSize() {
        return statusBarSize;
    }

    public void setStatusBarSize(StatusBarSize statusBarSize) {
        this.statusBarSize = statusBarSize;
    }
}

// https://developer.apple.com/documentation/xctest/xcuielementtypequeryprovider/1500428-statusbars
class StatusBarSize {
    public int width;

    public int height;

    public int getWidth() {
        return width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getHeight() {
        return height;
    }

    public void setHeight(int height) {
        this.height = height;
    }
}
