package com.kms.katalon.core.appium.driver;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;

import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpClient.Builder;
import org.openqa.selenium.remote.http.HttpClient.Factory;

import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;

public class RemoteAppiumClientFactory implements Factory {

    private org.openqa.selenium.remote.internal.OkHttpClient.Factory factory;

    private Proxy proxy;

    private Authenticator proxyAuthenticator;

    public RemoteAppiumClientFactory(Proxy proxy) {
        this(proxy, null, null);
    }

    public RemoteAppiumClientFactory(Proxy proxy, String proxyUsername, String proxyPw) {
        this.proxy = proxy;
        this.factory = new org.openqa.selenium.remote.internal.OkHttpClient.Factory();
        if (StringUtils.isNotBlank(proxyUsername) || StringUtils.isNotBlank(proxyPw)) {
            this.proxyAuthenticator = getProxyAuthenticator(proxyUsername, proxyPw);
        }
    }

    private Authenticator getProxyAuthenticator(String username, String pw) {
        return new Authenticator() {
            @Override
            public Request authenticate(Route route, Response response) throws IOException {
                String credential = Credentials.basic(username, pw);
                return response.request().newBuilder().header("Proxy-Authorization", credential).build();
            }
        };
    }

    @Override
    public org.openqa.selenium.remote.internal.OkHttpClient.Builder builder() {
        Builder builder = factory.builder();
        if (proxy == null) {
            return builder;
        }
        if (this.proxyAuthenticator == null) {
            return builder.proxy(proxy);
        } else {
            return new CustomOkHttpClientFactory(this.proxyAuthenticator);
        }
    }

    @Override
    public HttpClient createClient(URL url) {
        if (this.proxyAuthenticator == null) {
            return Factory.super.createClient(url);
        }
        OkHttpClient client = new OkHttpClient.Builder().proxy(this.proxy)
                .proxyAuthenticator(this.proxyAuthenticator)
                .connectTimeout(600, TimeUnit.SECONDS)
                .readTimeout(600, TimeUnit.SECONDS)
                .build();
        return new org.openqa.selenium.remote.internal.OkHttpClient(client, url);
    }

    @Override
    public void cleanupIdleClients() {
        factory.cleanupIdleClients();
    }
}
